/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationFilter;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.client.observation.ChatClientObservationDocumentation;
import org.springframework.ai.observation.tracing.TracingHelper;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ChatClientInputContentObservationFilter
implements ObservationFilter {
    public Observation.Context map(Observation.Context context) {
        if (!(context instanceof ChatClientObservationContext)) {
            return context;
        }
        ChatClientObservationContext chatClientObservationContext = (ChatClientObservationContext)context;
        this.chatClientSystemText(chatClientObservationContext);
        this.chatClientSystemParams(chatClientObservationContext);
        this.chatClientUserText(chatClientObservationContext);
        this.chatClientUserParams(chatClientObservationContext);
        return chatClientObservationContext;
    }

    protected void chatClientSystemText(ChatClientObservationContext context) {
        if (!StringUtils.hasText((String)context.getRequest().getSystemText())) {
            return;
        }
        context.addHighCardinalityKeyValue(KeyValue.of((KeyName)ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_SYSTEM_TEXT, (String)context.getRequest().getSystemText()));
    }

    protected void chatClientSystemParams(ChatClientObservationContext context) {
        if (CollectionUtils.isEmpty(context.getRequest().getSystemParams())) {
            return;
        }
        context.addHighCardinalityKeyValue(KeyValue.of((KeyName)ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_SYSTEM_PARAM, (String)TracingHelper.concatenateMaps(context.getRequest().getSystemParams())));
    }

    protected void chatClientUserText(ChatClientObservationContext context) {
        if (!StringUtils.hasText((String)context.getRequest().getUserText())) {
            return;
        }
        context.addHighCardinalityKeyValue(KeyValue.of((KeyName)ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_USER_TEXT, (String)context.getRequest().getUserText()));
    }

    protected void chatClientUserParams(ChatClientObservationContext context) {
        if (CollectionUtils.isEmpty(context.getRequest().getUserParams())) {
            return;
        }
        context.addHighCardinalityKeyValue(KeyValue.of((KeyName)ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_USER_PARAMS, (String)TracingHelper.concatenateMaps(context.getRequest().getUserParams())));
    }
}

