/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.client.observation.ChatClientObservationDocumentation;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.observation.conventions.SpringAiKind;
import org.springframework.ai.observation.tracing.TracingHelper;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class DefaultChatClientObservationConvention
implements ChatClientObservationConvention {
    public static final String DEFAULT_NAME = "spring.ai.chat.client";
    private final String name;

    public DefaultChatClientObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultChatClientObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getContextualName(ChatClientObservationContext context) {
        return "%s %s".formatted(context.getOperationMetadata().provider(), SpringAiKind.CHAT_CLIENT.value());
    }

    public KeyValues getLowCardinalityKeyValues(ChatClientObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.aiOperationType(context), this.aiProvider(context), this.springAiKind(), this.stream(context)});
    }

    protected KeyValue aiOperationType(ChatClientObservationContext context) {
        return KeyValue.of((KeyName)ChatModelObservationDocumentation.LowCardinalityKeyNames.AI_OPERATION_TYPE, (String)context.getOperationMetadata().operationType());
    }

    protected KeyValue aiProvider(ChatClientObservationContext context) {
        return KeyValue.of((KeyName)ChatModelObservationDocumentation.LowCardinalityKeyNames.AI_PROVIDER, (String)context.getOperationMetadata().provider());
    }

    protected KeyValue springAiKind() {
        return KeyValue.of((KeyName)ChatClientObservationDocumentation.LowCardinalityKeyNames.SPRING_AI_KIND, (String)SpringAiKind.CHAT_CLIENT.value());
    }

    protected KeyValue stream(ChatClientObservationContext context) {
        return KeyValue.of((KeyName)ChatClientObservationDocumentation.LowCardinalityKeyNames.STREAM, (String)("" + context.isStream()));
    }

    public KeyValues getHighCardinalityKeyValues(ChatClientObservationContext context) {
        KeyValues keyValues = KeyValues.empty();
        keyValues = this.chatClientAdvisorNames(keyValues, context);
        keyValues = this.chatClientAdvisorParams(keyValues, context);
        keyValues = this.toolFunctionNames(keyValues, context);
        keyValues = this.toolFunctionCallbacks(keyValues, context);
        return keyValues;
    }

    protected KeyValues chatClientAdvisorNames(KeyValues keyValues, ChatClientObservationContext context) {
        if (CollectionUtils.isEmpty(context.getRequest().getAdvisors())) {
            return keyValues;
        }
        List<String> advisorNames = context.getRequest().getAdvisors().stream().map(Advisor::getName).toList();
        return keyValues.and(ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_ADVISORS.asString(), TracingHelper.concatenateStrings(advisorNames));
    }

    protected KeyValues chatClientAdvisorParams(KeyValues keyValues, ChatClientObservationContext context) {
        if (CollectionUtils.isEmpty(context.getRequest().getAdvisorParams())) {
            return keyValues;
        }
        Map<String, Object> advisorParams = context.getRequest().getAdvisorParams();
        return keyValues.and(ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_ADVISOR_PARAMS.asString(), TracingHelper.concatenateMaps(advisorParams));
    }

    protected KeyValues toolFunctionNames(KeyValues keyValues, ChatClientObservationContext context) {
        if (CollectionUtils.isEmpty(context.getRequest().getFunctionNames())) {
            return keyValues;
        }
        List<String> functionNames = context.getRequest().getFunctionNames();
        return keyValues.and(ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_TOOL_FUNCTION_NAMES.asString(), TracingHelper.concatenateStrings(functionNames));
    }

    protected KeyValues toolFunctionCallbacks(KeyValues keyValues, ChatClientObservationContext context) {
        if (CollectionUtils.isEmpty(context.getRequest().getFunctionCallbacks())) {
            return keyValues;
        }
        List<String> functionCallbacks = context.getRequest().getFunctionCallbacks().stream().map(FunctionCallback::getName).toList();
        return keyValues.and(ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_TOOL_FUNCTION_CALLBACKS.asString(), TracingHelper.concatenateStrings(functionCallbacks));
    }
}

