/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.evaluation;

import java.util.Collections;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.evaluation.EvaluationRequest;
import org.springframework.ai.evaluation.EvaluationResponse;
import org.springframework.ai.evaluation.Evaluator;

public class RelevancyEvaluator
implements Evaluator {
    private static final String DEFAULT_EVALUATION_PROMPT_TEXT = "\tYour task is to evaluate if the response for the query\n\tis in line with the context information provided.\\n\n\tYou have two options to answer. Either YES/ NO.\\n\n\tAnswer - YES, if the response for the query\n\tis in line with context information otherwise NO.\\n\n\tQuery: \\n {query}\\n\n\tResponse: \\n {response}\\n\n\tContext: \\n {context}\\n\n\tAnswer: \"\n";
    private final ChatClient.Builder chatClientBuilder;

    public RelevancyEvaluator(ChatClient.Builder chatClientBuilder) {
        this.chatClientBuilder = chatClientBuilder;
    }

    @Override
    public EvaluationResponse evaluate(EvaluationRequest evaluationRequest) {
        String response = evaluationRequest.getResponseContent();
        String context = this.doGetSupportingData(evaluationRequest);
        String evaluationResponse = this.chatClientBuilder.build().prompt().user(userSpec -> userSpec.text(DEFAULT_EVALUATION_PROMPT_TEXT).param("query", evaluationRequest.getUserText()).param("response", response).param("context", context)).call().content();
        boolean passing = false;
        float score = 0.0f;
        if (evaluationResponse.toLowerCase().contains("yes")) {
            passing = true;
            score = 1.0f;
        }
        return new EvaluationResponse(passing, score, "", Collections.emptyMap());
    }
}

