/*
 * Copyright 2023-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.ai.chat.client.advisor.api;

import org.springframework.ai.template.TemplateRenderer;
import org.springframework.ai.template.st.StTemplateRenderer;

/**
 * A base interface for advisor chains that can be used to chain multiple advisors
 * together, both for call and stream advisors.
 *
 * @author Thomas Vitale
 * @since 1.0.0
 */
public interface BaseAdvisorChain extends CallAdvisorChain, StreamAdvisorChain {

	default TemplateRenderer getTemplateRenderer() {
		return StTemplateRenderer.builder().build();
	}

}
