/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.advisor.api.BaseAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.CallAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisor;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationContext;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationConvention;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationDocumentation;
import org.springframework.ai.chat.client.advisor.observation.DefaultAdvisorObservationConvention;
import org.springframework.ai.template.TemplateRenderer;
import org.springframework.ai.template.st.StTemplateRenderer;
import org.springframework.core.OrderComparator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class DefaultAroundAdvisorChain
implements BaseAdvisorChain {
    public static final AdvisorObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultAdvisorObservationConvention();
    private static final TemplateRenderer DEFAULT_TEMPLATE_RENDERER = StTemplateRenderer.builder().build();
    private final List<CallAroundAdvisor> originalCallAdvisors;
    private final List<StreamAroundAdvisor> originalStreamAdvisors;
    private final Deque<CallAroundAdvisor> callAroundAdvisors;
    private final Deque<StreamAroundAdvisor> streamAroundAdvisors;
    private final ObservationRegistry observationRegistry;
    private final TemplateRenderer templateRenderer;

    DefaultAroundAdvisorChain(ObservationRegistry observationRegistry, @Nullable TemplateRenderer templateRenderer, Deque<CallAroundAdvisor> callAroundAdvisors, Deque<StreamAroundAdvisor> streamAroundAdvisors) {
        Assert.notNull((Object)observationRegistry, (String)"the observationRegistry must be non-null");
        Assert.notNull(callAroundAdvisors, (String)"the callAroundAdvisors must be non-null");
        Assert.notNull(streamAroundAdvisors, (String)"the streamAroundAdvisors must be non-null");
        this.observationRegistry = observationRegistry;
        this.templateRenderer = templateRenderer != null ? templateRenderer : DEFAULT_TEMPLATE_RENDERER;
        this.callAroundAdvisors = callAroundAdvisors;
        this.streamAroundAdvisors = streamAroundAdvisors;
        this.originalCallAdvisors = List.copyOf(callAroundAdvisors);
        this.originalStreamAdvisors = List.copyOf(streamAroundAdvisors);
    }

    public static Builder builder(ObservationRegistry observationRegistry) {
        return new Builder(observationRegistry);
    }

    @Override
    public TemplateRenderer getTemplateRenderer() {
        return this.templateRenderer;
    }

    @Override
    public ChatClientResponse nextCall(ChatClientRequest chatClientRequest) {
        Assert.notNull((Object)chatClientRequest, (String)"the chatClientRequest cannot be null");
        if (this.callAroundAdvisors.isEmpty()) {
            throw new IllegalStateException("No CallAdvisors available to execute");
        }
        CallAroundAdvisor advisor = this.callAroundAdvisors.pop();
        AdvisorObservationContext observationContext = AdvisorObservationContext.builder().advisorName(advisor.getName()).chatClientRequest(chatClientRequest).order(advisor.getOrder()).build();
        return (ChatClientResponse)AdvisorObservationDocumentation.AI_ADVISOR.observation(null, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            if (advisor instanceof CallAdvisor) {
                CallAdvisor callAdvisor = (CallAdvisor)advisor;
                return callAdvisor.adviseCall(chatClientRequest, this);
            }
            AdvisedResponse advisedResponse = advisor.aroundCall(AdvisedRequest.from(chatClientRequest), this);
            ChatClientResponse chatClientResponse = advisedResponse.toChatClientResponse();
            observationContext.setChatClientResponse(chatClientResponse);
            return chatClientResponse;
        });
    }

    @Override
    @Deprecated
    public AdvisedResponse nextAroundCall(AdvisedRequest advisedRequest) {
        Assert.notNull((Object)advisedRequest, (String)"the advisedRequest cannot be null");
        if (this.callAroundAdvisors.isEmpty()) {
            throw new IllegalStateException("No AroundAdvisor available to execute");
        }
        CallAroundAdvisor advisor = this.callAroundAdvisors.pop();
        AdvisorObservationContext observationContext = AdvisorObservationContext.builder().advisorName(advisor.getName()).chatClientRequest(advisedRequest.toChatClientRequest(this.templateRenderer)).order(advisor.getOrder()).build();
        return (AdvisedResponse)AdvisorObservationDocumentation.AI_ADVISOR.observation(null, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            if (advisor instanceof CallAdvisor) {
                CallAdvisor callAdvisor = (CallAdvisor)advisor;
                ChatClientResponse chatClientResponse = callAdvisor.adviseCall(advisedRequest.toChatClientRequest(this.templateRenderer), this);
                return AdvisedResponse.from(chatClientResponse);
            }
            AdvisedResponse advisedResponse = advisor.aroundCall(advisedRequest, this);
            ChatClientResponse chatClientResponse = advisedResponse.toChatClientResponse();
            observationContext.setChatClientResponse(chatClientResponse);
            return advisedResponse;
        });
    }

    @Override
    public Flux<ChatClientResponse> nextStream(ChatClientRequest chatClientRequest) {
        Assert.notNull((Object)chatClientRequest, (String)"the chatClientRequest cannot be null");
        return Flux.deferContextual(contextView -> {
            if (this.streamAroundAdvisors.isEmpty()) {
                return Flux.error((Throwable)new IllegalStateException("No StreamAdvisors available to execute"));
            }
            StreamAroundAdvisor advisor = this.streamAroundAdvisors.pop();
            AdvisorObservationContext observationContext = AdvisorObservationContext.builder().advisorName(advisor.getName()).chatClientRequest(chatClientRequest).order(advisor.getOrder()).build();
            Observation observation = AdvisorObservationDocumentation.AI_ADVISOR.observation(null, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            return Flux.defer(() -> {
                if (advisor instanceof StreamAdvisor) {
                    StreamAdvisor streamAdvisor = (StreamAdvisor)advisor;
                    return streamAdvisor.adviseStream(chatClientRequest, this).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
                }
                return advisor.aroundStream(AdvisedRequest.from(chatClientRequest), this).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation)).map(AdvisedResponse::toChatClientResponse);
            });
        });
    }

    @Override
    @Deprecated
    public Flux<AdvisedResponse> nextAroundStream(AdvisedRequest advisedRequest) {
        Assert.notNull((Object)advisedRequest, (String)"the advisedRequest cannot be null");
        return Flux.deferContextual(contextView -> {
            if (this.streamAroundAdvisors.isEmpty()) {
                return Flux.error((Throwable)new IllegalStateException("No AroundAdvisor available to execute"));
            }
            StreamAroundAdvisor advisor = this.streamAroundAdvisors.pop();
            AdvisorObservationContext observationContext = AdvisorObservationContext.builder().advisorName(advisor.getName()).chatClientRequest(advisedRequest.toChatClientRequest(this.templateRenderer)).order(advisor.getOrder()).build();
            Observation observation = AdvisorObservationDocumentation.AI_ADVISOR.observation(null, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            return Flux.defer(() -> {
                if (advisor instanceof StreamAdvisor) {
                    StreamAdvisor streamAdvisor = (StreamAdvisor)advisor;
                    return streamAdvisor.adviseStream(advisedRequest.toChatClientRequest(this.templateRenderer), this).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation)).map(AdvisedResponse::from);
                }
                return advisor.aroundStream(advisedRequest, this).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            });
        });
    }

    @Override
    public List<CallAroundAdvisor> getCallAdvisors() {
        return this.originalCallAdvisors;
    }

    @Override
    public List<StreamAroundAdvisor> getStreamAdvisors() {
        return this.originalStreamAdvisors;
    }

    @Override
    public ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    public static class Builder {
        private final ObservationRegistry observationRegistry;
        private final Deque<CallAroundAdvisor> callAroundAdvisors;
        private final Deque<StreamAroundAdvisor> streamAroundAdvisors;
        private TemplateRenderer templateRenderer;

        public Builder(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            this.callAroundAdvisors = new ConcurrentLinkedDeque<CallAroundAdvisor>();
            this.streamAroundAdvisors = new ConcurrentLinkedDeque<StreamAroundAdvisor>();
        }

        public Builder templateRenderer(TemplateRenderer templateRenderer) {
            this.templateRenderer = templateRenderer;
            return this;
        }

        public Builder push(Advisor advisor) {
            Assert.notNull((Object)advisor, (String)"the advisor must be non-null");
            return this.pushAll(List.of(advisor));
        }

        public Builder pushAll(List<? extends Advisor> advisors) {
            Assert.notNull(advisors, (String)"the advisors must be non-null");
            Assert.noNullElements(advisors, (String)"the advisors must not contain null elements");
            if (!CollectionUtils.isEmpty(advisors)) {
                List<StreamAroundAdvisor> streamAroundAdvisorList;
                List<CallAroundAdvisor> callAroundAdvisorList = advisors.stream().filter(a -> a instanceof CallAroundAdvisor).map(a -> (CallAroundAdvisor)a).toList();
                if (!CollectionUtils.isEmpty(callAroundAdvisorList)) {
                    callAroundAdvisorList.forEach(this.callAroundAdvisors::push);
                }
                if (!CollectionUtils.isEmpty(streamAroundAdvisorList = advisors.stream().filter(a -> a instanceof StreamAroundAdvisor).map(a -> (StreamAroundAdvisor)a).toList())) {
                    streamAroundAdvisorList.forEach(this.streamAroundAdvisors::push);
                }
                this.reOrder();
            }
            return this;
        }

        private void reOrder() {
            ArrayList<CallAroundAdvisor> callAdvisors = new ArrayList<CallAroundAdvisor>(this.callAroundAdvisors);
            OrderComparator.sort(callAdvisors);
            this.callAroundAdvisors.clear();
            callAdvisors.forEach(this.callAroundAdvisors::addLast);
            ArrayList<StreamAroundAdvisor> streamAdvisors = new ArrayList<StreamAroundAdvisor>(this.streamAroundAdvisors);
            OrderComparator.sort(streamAdvisors);
            this.streamAroundAdvisors.clear();
            streamAdvisors.forEach(this.streamAroundAdvisors::addLast);
        }

        public DefaultAroundAdvisorChain build() {
            return new DefaultAroundAdvisorChain(this.observationRegistry, this.templateRenderer, this.callAroundAdvisors, this.streamAroundAdvisors);
        }
    }
}

