/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.ai.chat.client.ChatClientAttributes;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.content.Media;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.template.TemplateRenderer;
import org.springframework.ai.template.st.StTemplateRenderer;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public record AdvisedRequest(ChatModel chatModel, String userText, @Nullable String systemText, @Nullable ChatOptions chatOptions, List<Media> media, List<String> toolNames, List<ToolCallback> toolCallbacks, List<Message> messages, Map<String, Object> userParams, Map<String, Object> systemParams, List<Advisor> advisors, @Deprecated Map<String, Object> advisorParams, Map<String, Object> adviseContext, Map<String, Object> toolContext) {
    public AdvisedRequest {
        Assert.notNull((Object)chatModel, (String)"chatModel cannot be null");
        Assert.isTrue((StringUtils.hasText((String)userText) || !CollectionUtils.isEmpty(messages) ? 1 : 0) != 0, (String)"userText cannot be null or empty unless messages are provided and contain Tool Response message.");
        Assert.notNull(media, (String)"media cannot be null");
        Assert.noNullElements(media, (String)"media cannot contain null elements");
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        Assert.notNull(messages, (String)"messages cannot be null");
        Assert.noNullElements(messages, (String)"messages cannot contain null elements");
        Assert.notNull(userParams, (String)"userParams cannot be null");
        Assert.noNullElements(userParams.keySet(), (String)"userParams keys cannot contain null elements");
        Assert.noNullElements(userParams.values(), (String)"userParams values cannot contain null elements");
        Assert.notNull(systemParams, (String)"systemParams cannot be null");
        Assert.noNullElements(systemParams.keySet(), (String)"systemParams keys cannot contain null elements");
        Assert.noNullElements(systemParams.values(), (String)"systemParams values cannot contain null elements");
        Assert.notNull(advisors, (String)"advisors cannot be null");
        Assert.noNullElements(advisors, (String)"advisors cannot contain null elements");
        Assert.notNull(advisorParams, (String)"advisorParams cannot be null");
        Assert.noNullElements(advisorParams.keySet(), (String)"advisorParams keys cannot contain null elements");
        Assert.noNullElements(advisorParams.values(), (String)"advisorParams values cannot contain null elements");
        Assert.notNull(adviseContext, (String)"adviseContext cannot be null");
        Assert.noNullElements(adviseContext.keySet(), (String)"adviseContext keys cannot contain null elements");
        Assert.noNullElements(adviseContext.values(), (String)"adviseContext values cannot contain null elements");
        Assert.notNull(toolContext, (String)"toolContext cannot be null");
        Assert.noNullElements(toolContext.keySet(), (String)"toolContext keys cannot contain null elements");
        Assert.noNullElements(toolContext.values(), (String)"toolContext values cannot contain null elements");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(AdvisedRequest from) {
        Assert.notNull((Object)from, (String)"AdvisedRequest cannot be null");
        Builder builder = new Builder();
        builder.chatModel = from.chatModel;
        builder.userText = from.userText;
        builder.systemText = from.systemText;
        builder.chatOptions = from.chatOptions;
        builder.media = from.media;
        builder.toolNames = from.toolNames;
        builder.toolCallbacks = from.toolCallbacks;
        builder.messages = from.messages;
        builder.userParams = from.userParams;
        builder.systemParams = from.systemParams;
        builder.advisors = from.advisors;
        builder.advisorParams = from.advisorParams;
        builder.adviseContext = from.adviseContext;
        builder.toolContext = from.toolContext;
        return builder;
    }

    public static AdvisedRequest from(ChatClientRequest from) {
        Assert.notNull((Object)from, (String)"ChatClientRequest cannot be null");
        LinkedList<Message> messages = new LinkedList<Message>(from.prompt().getInstructions());
        Builder builder = new Builder();
        Object object = from.context().get(ChatClientAttributes.CHAT_MODEL.getKey());
        if (object instanceof ChatModel) {
            ChatModel chatModel;
            builder.chatModel = chatModel = (ChatModel)object;
        }
        if (!messages.isEmpty() && (object = messages.get(messages.size() - 1)) instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)object;
            builder.userText = userMessage.getText();
            builder.media = userMessage.getMedia();
            messages.remove(messages.size() - 1);
        }
        if ((object = from.context().get(ChatClientAttributes.USER_PARAMS.getKey())) instanceof Map) {
            Map contextUserParams;
            builder.userParams = contextUserParams = (Map)object;
        }
        if (!messages.isEmpty() && (object = messages.get(messages.size() - 1)) instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)object;
            builder.systemText = systemMessage.getText();
            messages.remove(messages.size() - 1);
        }
        if ((object = from.context().get(ChatClientAttributes.SYSTEM_PARAMS.getKey())) instanceof Map) {
            Map contextSystemParams;
            builder.systemParams = contextSystemParams = (Map)object;
        }
        builder.messages = messages;
        builder.chatOptions = Objects.requireNonNullElse(from.prompt().getOptions(), ChatOptions.builder().build());
        object = from.prompt().getOptions();
        if (object instanceof ToolCallingChatOptions) {
            ToolCallingChatOptions options = (ToolCallingChatOptions)object;
            builder.toolNames = options.getToolNames().stream().toList();
            builder.toolCallbacks = options.getToolCallbacks();
            builder.toolContext = options.getToolContext();
        }
        if ((object = from.context().get(ChatClientAttributes.ADVISORS.getKey())) instanceof List) {
            List advisors;
            builder.advisors = advisors = (List)object;
        }
        builder.advisorParams = Map.of();
        builder.adviseContext = from.context();
        return builder.build();
    }

    public AdvisedRequest updateContext(Function<Map<String, Object>, Map<String, Object>> contextTransform) {
        Assert.notNull(contextTransform, (String)"contextTransform cannot be null");
        return AdvisedRequest.from(this).adviseContext(Collections.unmodifiableMap(contextTransform.apply(new HashMap<String, Object>(this.adviseContext)))).build();
    }

    public ChatClientRequest toChatClientRequest() {
        return this.toChatClientRequest((TemplateRenderer)StTemplateRenderer.builder().build());
    }

    public ChatClientRequest toChatClientRequest(TemplateRenderer templateRenderer) {
        return ChatClientRequest.builder().prompt(this.toPrompt(templateRenderer)).context(this.adviseContext).context(ChatClientAttributes.ADVISORS.getKey(), this.advisors).context(ChatClientAttributes.CHAT_MODEL.getKey(), this.chatModel).context(ChatClientAttributes.USER_PARAMS.getKey(), this.userParams).context(ChatClientAttributes.SYSTEM_PARAMS.getKey(), this.systemParams).build();
    }

    public Prompt toPrompt() {
        return this.toPrompt((TemplateRenderer)StTemplateRenderer.builder().build());
    }

    public Prompt toPrompt(TemplateRenderer templateRenderer) {
        ChatOptions chatOptions;
        ArrayList<Message> messages = new ArrayList<Message>(this.messages());
        String processedSystemText = this.systemText();
        if (StringUtils.hasText((String)processedSystemText)) {
            if (!CollectionUtils.isEmpty(this.systemParams())) {
                processedSystemText = PromptTemplate.builder().template(processedSystemText).variables(this.systemParams()).renderer(templateRenderer).build().render();
            }
            messages.add((Message)new SystemMessage(processedSystemText));
        }
        if (StringUtils.hasText((String)this.userText())) {
            HashMap<String, Object> userParams = new HashMap<String, Object>(this.userParams());
            String processedUserText = this.userText();
            if (!CollectionUtils.isEmpty(userParams)) {
                processedUserText = PromptTemplate.builder().template(processedUserText).variables(userParams).renderer(templateRenderer).build().render();
            }
            messages.add((Message)new UserMessage(processedUserText, this.media()));
        }
        if ((chatOptions = this.chatOptions()) instanceof ToolCallingChatOptions) {
            ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
            if (!this.toolNames().isEmpty()) {
                toolCallingChatOptions.setToolNames(new HashSet<String>(this.toolNames()));
            }
            if (!this.toolCallbacks().isEmpty()) {
                toolCallingChatOptions.setToolCallbacks(this.toolCallbacks());
            }
            if (!CollectionUtils.isEmpty(this.toolContext())) {
                toolCallingChatOptions.setToolContext(this.toolContext());
            }
        }
        return new Prompt(messages, this.chatOptions());
    }

    public static final class Builder {
        private ChatModel chatModel;
        private String userText;
        private String systemText;
        private ChatOptions chatOptions;
        private List<Media> media = List.of();
        private List<String> toolNames = List.of();
        private List<ToolCallback> toolCallbacks = List.of();
        private List<Message> messages = List.of();
        private Map<String, Object> userParams = Map.of();
        private Map<String, Object> systemParams = Map.of();
        private List<Advisor> advisors = List.of();
        private Map<String, Object> advisorParams = Map.of();
        private Map<String, Object> adviseContext = Map.of();
        public Map<String, Object> toolContext = Map.of();

        private Builder() {
        }

        public Builder chatModel(ChatModel chatModel) {
            this.chatModel = chatModel;
            return this;
        }

        public Builder userText(String userText) {
            this.userText = userText;
            return this;
        }

        public Builder systemText(String systemText) {
            this.systemText = systemText;
            return this;
        }

        public Builder chatOptions(ChatOptions chatOptions) {
            this.chatOptions = chatOptions;
            return this;
        }

        public Builder media(List<Media> media) {
            this.media = media;
            return this;
        }

        public Builder toolNames(List<String> toolNames) {
            this.toolNames = toolNames;
            return this;
        }

        public Builder functionCallbacks(List<ToolCallback> toolCallbacks) {
            this.toolCallbacks = toolCallbacks;
            return this;
        }

        public Builder messages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public Builder userParams(Map<String, Object> userParams) {
            this.userParams = userParams;
            return this;
        }

        public Builder systemParams(Map<String, Object> systemParams) {
            this.systemParams = systemParams;
            return this;
        }

        public Builder advisors(List<Advisor> advisors) {
            this.advisors = advisors;
            return this;
        }

        @Deprecated
        public Builder advisorParams(Map<String, Object> advisorParams) {
            this.advisorParams = advisorParams;
            return this;
        }

        public Builder adviseContext(Map<String, Object> adviseContext) {
            this.adviseContext = adviseContext;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            this.toolContext = toolContext;
            return this;
        }

        public AdvisedRequest build() {
            return new AdvisedRequest(this.chatModel, this.userText, this.systemText, this.chatOptions, this.media, this.toolNames, this.toolCallbacks, this.messages, this.userParams, this.systemParams, this.advisors, this.advisorParams, this.adviseContext, this.toolContext);
        }
    }
}

