/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor.api;

import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.AdvisorUtils;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponseStreamUtils;
import org.springframework.ai.chat.client.advisor.api.AdvisorChain;
import org.springframework.ai.chat.client.advisor.api.CallAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisorChain;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public interface BaseAdvisor
extends CallAdvisor,
StreamAdvisor {
    public static final Scheduler DEFAULT_SCHEDULER = Schedulers.boundedElastic();

    @Override
    default public ChatClientResponse adviseCall(ChatClientRequest chatClientRequest, CallAroundAdvisorChain chain) {
        ChatClientResponse chatClientResponse;
        Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest cannot be null");
        Assert.notNull((Object)chain, (String)"chain cannot be null");
        ChatClientRequest processedChatClientRequest = this.before(chatClientRequest, chain);
        if (chain instanceof CallAdvisorChain) {
            CallAdvisorChain callAdvisorChain = (CallAdvisorChain)chain;
            chatClientResponse = callAdvisorChain.nextCall(processedChatClientRequest);
        } else {
            chatClientResponse = chain.nextAroundCall(AdvisedRequest.from(processedChatClientRequest)).toChatClientResponse();
        }
        return this.after(chatClientResponse, chain);
    }

    @Override
    @Deprecated
    default public AdvisedResponse aroundCall(AdvisedRequest advisedRequest, CallAroundAdvisorChain chain) {
        Assert.notNull((Object)advisedRequest, (String)"advisedRequest cannot be null");
        Assert.notNull((Object)chain, (String)"chain cannot be null");
        AdvisedRequest processedAdvisedRequest = this.before(advisedRequest);
        AdvisedResponse advisedResponse = chain.nextAroundCall(processedAdvisedRequest);
        return this.after(advisedResponse);
    }

    @Override
    default public Flux<ChatClientResponse> adviseStream(ChatClientRequest chatClientRequest, StreamAroundAdvisorChain chain) {
        Flux chatClientResponseFlux;
        Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest cannot be null");
        Assert.notNull((Object)chain, (String)"chain cannot be null");
        Assert.notNull((Object)this.getScheduler(), (String)"scheduler cannot be null");
        if (chain instanceof StreamAdvisorChain) {
            StreamAdvisorChain streamAdvisorChain = (StreamAdvisorChain)chain;
            chatClientResponseFlux = Mono.just((Object)chatClientRequest).publishOn(this.getScheduler()).map(request -> this.before((ChatClientRequest)request, streamAdvisorChain)).flatMapMany(streamAdvisorChain::nextStream);
        } else {
            chatClientResponseFlux = Mono.just((Object)AdvisedRequest.from(chatClientRequest)).publishOn(this.getScheduler()).map(this::before).flatMapMany(chain::nextAroundStream).map(AdvisedResponse::toChatClientResponse);
        }
        return chatClientResponseFlux.map(response -> {
            if (AdvisorUtils.onFinishReason().test((ChatClientResponse)response)) {
                response = this.after((ChatClientResponse)response, chain);
            }
            return response;
        }).onErrorResume(error -> Flux.error((Throwable)new IllegalStateException("Stream processing failed", (Throwable)error)));
    }

    @Override
    @Deprecated
    default public Flux<AdvisedResponse> aroundStream(AdvisedRequest advisedRequest, StreamAroundAdvisorChain chain) {
        Assert.notNull((Object)advisedRequest, (String)"advisedRequest cannot be null");
        Assert.notNull((Object)chain, (String)"chain cannot be null");
        Assert.notNull((Object)this.getScheduler(), (String)"scheduler cannot be null");
        Flux advisedResponses = Mono.just((Object)advisedRequest).publishOn(this.getScheduler()).map(this::before).flatMapMany(chain::nextAroundStream);
        return advisedResponses.map(ar -> {
            if (AdvisedResponseStreamUtils.onFinishReason().test((AdvisedResponse)ar)) {
                ar = this.after((AdvisedResponse)ar);
            }
            return ar;
        }).onErrorResume(error -> Flux.error((Throwable)new IllegalStateException("Stream processing failed", (Throwable)error)));
    }

    @Override
    default public String getName() {
        return this.getClass().getSimpleName();
    }

    default public ChatClientRequest before(ChatClientRequest chatClientRequest, AdvisorChain advisorChain) {
        Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest cannot be null");
        return this.before(AdvisedRequest.from(chatClientRequest)).toChatClientRequest();
    }

    default public ChatClientResponse after(ChatClientResponse chatClientResponse, AdvisorChain advisorChain) {
        Assert.notNull((Object)chatClientResponse, (String)"chatClientResponse cannot be null");
        return this.after(AdvisedResponse.from(chatClientResponse)).toChatClientResponse();
    }

    @Deprecated
    public AdvisedRequest before(AdvisedRequest var1);

    @Deprecated
    public AdvisedResponse after(AdvisedResponse var1);

    default public Scheduler getScheduler() {
        return DEFAULT_SCHEDULER;
    }
}

