/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.observation;

import io.micrometer.observation.Observation;
import java.util.List;
import org.springframework.ai.chat.client.ChatClientAttributes;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.observation.AiOperationMetadata;
import org.springframework.ai.observation.conventions.AiOperationType;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ChatClientObservationContext
extends Observation.Context {
    private final ChatClientRequest request;
    private final AiOperationMetadata operationMetadata = new AiOperationMetadata(AiOperationType.FRAMEWORK.value(), AiProvider.SPRING_AI.value());
    private final List<? extends Advisor> advisors;
    private final boolean stream;

    ChatClientObservationContext(ChatClientRequest chatClientRequest, List<? extends Advisor> advisors, boolean isStream) {
        Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest cannot be null");
        Assert.notNull(advisors, (String)"advisors cannot be null");
        Assert.noNullElements(advisors, (String)"advisors cannot contain null elements");
        this.request = chatClientRequest;
        this.advisors = advisors;
        this.stream = isStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ChatClientRequest getRequest() {
        return this.request;
    }

    public AiOperationMetadata getOperationMetadata() {
        return this.operationMetadata;
    }

    public List<? extends Advisor> getAdvisors() {
        return this.advisors;
    }

    public boolean isStream() {
        return this.stream;
    }

    @Nullable
    @Deprecated
    public String getFormat() {
        Object object = this.request.context().get(ChatClientAttributes.OUTPUT_FORMAT.getKey());
        if (object instanceof String) {
            String format = (String)object;
            return format;
        }
        return null;
    }

    @Deprecated
    public void setFormat(@Nullable String format) {
        this.request.context().put(ChatClientAttributes.OUTPUT_FORMAT.getKey(), format);
    }

    public static final class Builder {
        private ChatClientRequest chatClientRequest;
        private List<? extends Advisor> advisors = List.of();
        private String format;
        private boolean isStream = false;

        private Builder() {
        }

        public Builder request(ChatClientRequest chatClientRequest) {
            this.chatClientRequest = chatClientRequest;
            return this;
        }

        @Deprecated
        public Builder withRequest(ChatClientRequest chatClientRequest) {
            return this.request(chatClientRequest);
        }

        @Deprecated
        public Builder withFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder advisors(List<? extends Advisor> advisors) {
            this.advisors = advisors;
            return this;
        }

        public Builder stream(boolean isStream) {
            this.isStream = isStream;
            return this;
        }

        @Deprecated
        public Builder withStream(boolean isStream) {
            return this.stream(isStream);
        }

        public ChatClientObservationContext build() {
            if (StringUtils.hasText((String)this.format)) {
                this.chatClientRequest.context().put(ChatClientAttributes.OUTPUT_FORMAT.getKey(), this.format);
            }
            return new ChatClientObservationContext(this.chatClientRequest, this.advisors, this.isStream);
        }
    }
}

