/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.observation.tracing.TracingHelper;
import org.springframework.util.CollectionUtils;

public final class ChatClientPromptContentObservationFilter
implements ObservationFilter {
    public Observation.Context map(Observation.Context context) {
        if (!(context instanceof ChatClientObservationContext)) {
            return context;
        }
        ChatClientObservationContext chatClientObservationContext = (ChatClientObservationContext)context;
        Map<String, Object> prompts = this.processPrompt(chatClientObservationContext);
        chatClientObservationContext.addHighCardinalityKeyValue(ChatModelObservationDocumentation.HighCardinalityKeyNames.PROMPT.withValue(TracingHelper.concatenateMaps(prompts)));
        return chatClientObservationContext;
    }

    private Map<String, Object> processPrompt(ChatClientObservationContext context) {
        if (CollectionUtils.isEmpty((Collection)context.getRequest().prompt().getInstructions())) {
            return Map.of();
        }
        HashMap<String, Object> messages = new HashMap<String, Object>();
        context.getRequest().prompt().getInstructions().forEach(message -> messages.put(message.getMessageType().getValue(), message.getText()));
        return messages;
    }
}

