/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.client.observation.ChatClientObservationDocumentation;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.observation.ObservabilityHelper;
import org.springframework.ai.observation.conventions.SpringAiKind;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultChatClientObservationConvention
implements ChatClientObservationConvention {
    public static final String DEFAULT_NAME = "spring.ai.chat.client";
    private final String name;

    public DefaultChatClientObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultChatClientObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getContextualName(ChatClientObservationContext context) {
        return "%s %s".formatted(context.getOperationMetadata().provider(), SpringAiKind.CHAT_CLIENT.value());
    }

    public KeyValues getLowCardinalityKeyValues(ChatClientObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.aiOperationType(context), this.aiProvider(context), this.springAiKind(), this.stream(context)});
    }

    protected KeyValue aiOperationType(ChatClientObservationContext context) {
        return KeyValue.of((KeyName)ChatModelObservationDocumentation.LowCardinalityKeyNames.AI_OPERATION_TYPE, (String)context.getOperationMetadata().operationType());
    }

    protected KeyValue aiProvider(ChatClientObservationContext context) {
        return KeyValue.of((KeyName)ChatModelObservationDocumentation.LowCardinalityKeyNames.AI_PROVIDER, (String)context.getOperationMetadata().provider());
    }

    protected KeyValue springAiKind() {
        return KeyValue.of((KeyName)ChatClientObservationDocumentation.LowCardinalityKeyNames.SPRING_AI_KIND, (String)SpringAiKind.CHAT_CLIENT.value());
    }

    protected KeyValue stream(ChatClientObservationContext context) {
        return KeyValue.of((KeyName)ChatClientObservationDocumentation.LowCardinalityKeyNames.STREAM, (String)("" + context.isStream()));
    }

    public KeyValues getHighCardinalityKeyValues(ChatClientObservationContext context) {
        KeyValues keyValues = KeyValues.empty();
        keyValues = this.advisors(keyValues, context);
        keyValues = this.conversationId(keyValues, context);
        keyValues = this.tools(keyValues, context);
        return keyValues;
    }

    protected KeyValues advisors(KeyValues keyValues, ChatClientObservationContext context) {
        if (CollectionUtils.isEmpty(context.getAdvisors())) {
            return keyValues;
        }
        List<String> advisorNames = context.getAdvisors().stream().map(Advisor::getName).toList();
        return keyValues.and(ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_ADVISORS.asString(), ObservabilityHelper.concatenateStrings(advisorNames));
    }

    protected KeyValues conversationId(KeyValues keyValues, ChatClientObservationContext context) {
        String conversationId;
        if (CollectionUtils.isEmpty(context.getRequest().context())) {
            return keyValues;
        }
        Object conversationIdValue = context.getRequest().context().get("chat_memory_conversation_id");
        if (!(conversationIdValue instanceof String) || !StringUtils.hasText((String)(conversationId = (String)conversationIdValue))) {
            return keyValues;
        }
        return keyValues.and(ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_CONVERSATION_ID.asString(), conversationId);
    }

    protected KeyValues tools(KeyValues keyValues, ChatClientObservationContext context) {
        if (context.getRequest().prompt().getOptions() == null) {
            return keyValues;
        }
        ChatOptions chatOptions = context.getRequest().prompt().getOptions();
        if (!(chatOptions instanceof ToolCallingChatOptions)) {
            return keyValues;
        }
        ToolCallingChatOptions options = (ToolCallingChatOptions)chatOptions;
        ArrayList toolNames = new ArrayList(options.getToolNames());
        List toolCallbacks = options.getToolCallbacks();
        if (CollectionUtils.isEmpty(toolNames) && CollectionUtils.isEmpty((Collection)toolCallbacks)) {
            return keyValues;
        }
        toolCallbacks.forEach(toolCallback -> toolNames.add(toolCallback.getToolDefinition().name()));
        return keyValues.and(ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_TOOL_NAMES.asString(), ObservabilityHelper.concatenateStrings(toolNames.stream().sorted().toList()));
    }
}

