/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.evaluation;

import java.util.Collections;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.evaluation.EvaluationRequest;
import org.springframework.ai.evaluation.EvaluationResponse;
import org.springframework.ai.evaluation.Evaluator;

public class FactCheckingEvaluator
implements Evaluator {
    private static final String DEFAULT_EVALUATION_PROMPT_TEXT = "\tEvaluate whether or not the following claim is supported by the provided document.\n\tRespond with \"yes\" if the claim is supported, or \"no\" if it is not.\n\tDocument: \\n {document}\\n\n\tClaim: \\n {claim}\n";
    private static final String BESPOKE_EVALUATION_PROMPT_TEXT = "\tDocument: \\n {document}\\n\n\tClaim: \\n {claim}\n";
    private final ChatClient.Builder chatClientBuilder;
    private final String evaluationPrompt;

    public FactCheckingEvaluator(ChatClient.Builder chatClientBuilder) {
        this(chatClientBuilder, DEFAULT_EVALUATION_PROMPT_TEXT);
    }

    public FactCheckingEvaluator(ChatClient.Builder chatClientBuilder, String evaluationPrompt) {
        this.chatClientBuilder = chatClientBuilder;
        this.evaluationPrompt = evaluationPrompt;
    }

    public static FactCheckingEvaluator forBespokeMinicheck(ChatClient.Builder chatClientBuilder) {
        return new FactCheckingEvaluator(chatClientBuilder, BESPOKE_EVALUATION_PROMPT_TEXT);
    }

    public EvaluationResponse evaluate(EvaluationRequest evaluationRequest) {
        String response = evaluationRequest.getResponseContent();
        String context = this.doGetSupportingData(evaluationRequest);
        String evaluationResponse = this.chatClientBuilder.build().prompt().user(userSpec -> userSpec.text(this.evaluationPrompt).param("document", context).param("claim", response)).call().content();
        boolean passing = "yes".equalsIgnoreCase(evaluationResponse);
        return new EvaluationResponse(passing, "", Collections.emptyMap());
    }
}

