/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.google.genai.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.GenerateContentResponseUsageMetadata;
import com.google.genai.types.ModalityTokenCount;
import java.util.List;
import java.util.Optional;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.google.genai.metadata.GoogleGenAiModalityTokenCount;
import org.springframework.ai.google.genai.metadata.GoogleGenAiTrafficType;
import org.springframework.lang.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GoogleGenAiUsage
extends DefaultUsage {
    @Nullable
    private final Integer thoughtsTokenCount;
    @Nullable
    private final Integer cachedContentTokenCount;
    @Nullable
    private final Integer toolUsePromptTokenCount;
    @Nullable
    private final List<GoogleGenAiModalityTokenCount> promptTokensDetails;
    @Nullable
    private final List<GoogleGenAiModalityTokenCount> candidatesTokensDetails;
    @Nullable
    private final List<GoogleGenAiModalityTokenCount> cacheTokensDetails;
    @Nullable
    private final List<GoogleGenAiModalityTokenCount> toolUsePromptTokensDetails;
    @Nullable
    private final GoogleGenAiTrafficType trafficType;

    public GoogleGenAiUsage(Integer promptTokens, Integer completionTokens, Integer totalTokens, @Nullable Integer thoughtsTokenCount, @Nullable Integer cachedContentTokenCount, @Nullable Integer toolUsePromptTokenCount, @Nullable List<GoogleGenAiModalityTokenCount> promptTokensDetails, @Nullable List<GoogleGenAiModalityTokenCount> candidatesTokensDetails, @Nullable List<GoogleGenAiModalityTokenCount> cacheTokensDetails, @Nullable List<GoogleGenAiModalityTokenCount> toolUsePromptTokensDetails, @Nullable GoogleGenAiTrafficType trafficType, @Nullable GenerateContentResponseUsageMetadata nativeUsage) {
        super(promptTokens, completionTokens, totalTokens, (Object)nativeUsage);
        this.thoughtsTokenCount = thoughtsTokenCount;
        this.cachedContentTokenCount = cachedContentTokenCount;
        this.toolUsePromptTokenCount = toolUsePromptTokenCount;
        this.promptTokensDetails = promptTokensDetails;
        this.candidatesTokensDetails = candidatesTokensDetails;
        this.cacheTokensDetails = cacheTokensDetails;
        this.toolUsePromptTokensDetails = toolUsePromptTokensDetails;
        this.trafficType = trafficType;
    }

    public static GoogleGenAiUsage from(GenerateContentResponseUsageMetadata usageMetadata) {
        if (usageMetadata == null) {
            return new GoogleGenAiUsage(0, 0, 0, null, null, null, null, null, null, null, null, null);
        }
        Integer promptTokens = usageMetadata.promptTokenCount().orElse(0);
        Integer completionTokens = usageMetadata.candidatesTokenCount().orElse(0);
        Integer totalTokens = usageMetadata.totalTokenCount().orElse(0);
        Integer thoughtsTokens = usageMetadata.thoughtsTokenCount().orElse(null);
        Integer cachedContentTokens = usageMetadata.cachedContentTokenCount().orElse(null);
        Integer toolUsePromptTokens = usageMetadata.toolUsePromptTokenCount().orElse(null);
        List<GoogleGenAiModalityTokenCount> promptDetails = GoogleGenAiUsage.convertModalityDetails(usageMetadata.promptTokensDetails());
        List<GoogleGenAiModalityTokenCount> candidatesDetails = GoogleGenAiUsage.convertModalityDetails(usageMetadata.candidatesTokensDetails());
        List<GoogleGenAiModalityTokenCount> cacheDetails = GoogleGenAiUsage.convertModalityDetails(usageMetadata.cacheTokensDetails());
        List<GoogleGenAiModalityTokenCount> toolUseDetails = GoogleGenAiUsage.convertModalityDetails(usageMetadata.toolUsePromptTokensDetails());
        GoogleGenAiTrafficType trafficType = usageMetadata.trafficType().map(GoogleGenAiTrafficType::from).orElse(null);
        return new GoogleGenAiUsage(promptTokens, completionTokens, totalTokens, thoughtsTokens, cachedContentTokens, toolUsePromptTokens, promptDetails, candidatesDetails, cacheDetails, toolUseDetails, trafficType, usageMetadata);
    }

    private static List<GoogleGenAiModalityTokenCount> convertModalityDetails(Optional<List<ModalityTokenCount>> modalityTokens) {
        return modalityTokens.map(tokens -> tokens.stream().map(GoogleGenAiModalityTokenCount::from).toList()).orElse(null);
    }

    @JsonProperty(value="thoughtsTokenCount")
    @Nullable
    public Integer getThoughtsTokenCount() {
        return this.thoughtsTokenCount;
    }

    @JsonProperty(value="cachedContentTokenCount")
    @Nullable
    public Integer getCachedContentTokenCount() {
        return this.cachedContentTokenCount;
    }

    @JsonProperty(value="toolUsePromptTokenCount")
    @Nullable
    public Integer getToolUsePromptTokenCount() {
        return this.toolUsePromptTokenCount;
    }

    @JsonProperty(value="promptTokensDetails")
    @Nullable
    public List<GoogleGenAiModalityTokenCount> getPromptTokensDetails() {
        return this.promptTokensDetails;
    }

    @JsonProperty(value="candidatesTokensDetails")
    @Nullable
    public List<GoogleGenAiModalityTokenCount> getCandidatesTokensDetails() {
        return this.candidatesTokensDetails;
    }

    @JsonProperty(value="cacheTokensDetails")
    @Nullable
    public List<GoogleGenAiModalityTokenCount> getCacheTokensDetails() {
        return this.cacheTokensDetails;
    }

    @JsonProperty(value="toolUsePromptTokensDetails")
    @Nullable
    public List<GoogleGenAiModalityTokenCount> getToolUsePromptTokensDetails() {
        return this.toolUsePromptTokensDetails;
    }

    @JsonProperty(value="trafficType")
    @Nullable
    public GoogleGenAiTrafficType getTrafficType() {
        return this.trafficType;
    }

    public String toString() {
        return "GoogleGenAiUsage{promptTokens=" + this.getPromptTokens() + ", completionTokens=" + this.getCompletionTokens() + ", totalTokens=" + this.getTotalTokens() + ", thoughtsTokenCount=" + this.thoughtsTokenCount + ", cachedContentTokenCount=" + this.cachedContentTokenCount + ", toolUsePromptTokenCount=" + this.toolUsePromptTokenCount + ", trafficType=" + String.valueOf((Object)this.trafficType) + "}";
    }
}

