/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.mcp.client;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.ClientMcpTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.ai.autoconfigure.mcp.client.NamedClientMcpTransport;
import org.springframework.ai.autoconfigure.mcp.client.SseHttpClientTransportAutoConfiguration;
import org.springframework.ai.autoconfigure.mcp.client.SseWebFluxTransportAutoConfiguration;
import org.springframework.ai.autoconfigure.mcp.client.StdioTransportAutoConfiguration;
import org.springframework.ai.autoconfigure.mcp.client.configurer.McpAsyncClientConfigurer;
import org.springframework.ai.autoconfigure.mcp.client.configurer.McpSyncClientConfigurer;
import org.springframework.ai.autoconfigure.mcp.client.properties.McpClientCommonProperties;
import org.springframework.ai.mcp.AsyncMcpToolCallbackProvider;
import org.springframework.ai.mcp.SyncMcpToolCallbackProvider;
import org.springframework.ai.mcp.customizer.McpAsyncClientCustomizer;
import org.springframework.ai.mcp.customizer.McpSyncClientCustomizer;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.CollectionUtils;

@AutoConfiguration(after={StdioTransportAutoConfiguration.class, SseHttpClientTransportAutoConfiguration.class, SseWebFluxTransportAutoConfiguration.class})
@ConditionalOnClass(value={McpSchema.class})
@EnableConfigurationProperties(value={McpClientCommonProperties.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class McpClientAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public List<McpSyncClient> mcpSyncClients(McpSyncClientConfigurer mcpSyncClientConfigurer, McpClientCommonProperties commonProperties, ObjectProvider<List<NamedClientMcpTransport>> transportsProvider) {
        ArrayList<McpSyncClient> mcpSyncClients = new ArrayList<McpSyncClient>();
        List namedTransports = transportsProvider.stream().flatMap(Collection::stream).toList();
        if (!CollectionUtils.isEmpty(namedTransports)) {
            for (NamedClientMcpTransport namedTransport : namedTransports) {
                McpSchema.Implementation clientInfo = new McpSchema.Implementation(commonProperties.getName(), commonProperties.getVersion());
                McpClient.SyncSpec syncSpec = McpClient.sync((ClientMcpTransport)namedTransport.transport()).clientInfo(clientInfo).requestTimeout(commonProperties.getRequestTimeout());
                syncSpec = mcpSyncClientConfigurer.configure(namedTransport.name(), syncSpec);
                McpSyncClient syncClient = syncSpec.build();
                if (commonProperties.isInitialized()) {
                    syncClient.initialize();
                }
                mcpSyncClients.add(syncClient);
            }
        }
        return mcpSyncClients;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public ToolCallbackProvider toolCallbacks(ObjectProvider<List<McpSyncClient>> mcpClientsProvider) {
        List mcpClients = mcpClientsProvider.stream().flatMap(Collection::stream).toList();
        return new SyncMcpToolCallbackProvider(mcpClients);
    }

    @Deprecated
    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public List<ToolCallback> toolCallbacksDeprecated(ObjectProvider<List<McpSyncClient>> mcpClientsProvider) {
        List mcpClients = mcpClientsProvider.stream().flatMap(Collection::stream).toList();
        return List.of(new SyncMcpToolCallbackProvider(mcpClients).getToolCallbacks());
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public CloseableMcpSyncClients makeSyncClientsClosable(List<McpSyncClient> clients) {
        return new CloseableMcpSyncClients(clients);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    McpSyncClientConfigurer mcpSyncClientConfigurer(ObjectProvider<McpSyncClientCustomizer> customizerProvider) {
        return new McpSyncClientConfigurer(customizerProvider.orderedStream().toList());
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public List<McpAsyncClient> mcpAsyncClients(McpAsyncClientConfigurer mcpSyncClientConfigurer, McpClientCommonProperties commonProperties, ObjectProvider<List<NamedClientMcpTransport>> transportsProvider) {
        ArrayList<McpAsyncClient> mcpSyncClients = new ArrayList<McpAsyncClient>();
        List namedTransports = transportsProvider.stream().flatMap(Collection::stream).toList();
        if (!CollectionUtils.isEmpty(namedTransports)) {
            for (NamedClientMcpTransport namedTransport : namedTransports) {
                McpSchema.Implementation clientInfo = new McpSchema.Implementation(commonProperties.getName(), commonProperties.getVersion());
                McpClient.AsyncSpec syncSpec = McpClient.async((ClientMcpTransport)namedTransport.transport()).clientInfo(clientInfo).requestTimeout(commonProperties.getRequestTimeout());
                syncSpec = mcpSyncClientConfigurer.configure(namedTransport.name(), syncSpec);
                McpAsyncClient syncClient = syncSpec.build();
                if (commonProperties.isInitialized()) {
                    syncClient.initialize();
                }
                mcpSyncClients.add(syncClient);
            }
        }
        return mcpSyncClients;
    }

    @Deprecated
    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public List<ToolCallback> asyncToolCallbacksDeprecated(ObjectProvider<List<McpAsyncClient>> mcpClientsProvider) {
        List mcpClients = mcpClientsProvider.stream().flatMap(Collection::stream).toList();
        return List.of(new AsyncMcpToolCallbackProvider(mcpClients).getToolCallbacks());
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public ToolCallbackProvider asyncToolCallbacks(ObjectProvider<List<McpAsyncClient>> mcpClientsProvider) {
        List mcpClients = mcpClientsProvider.stream().flatMap(Collection::stream).toList();
        return new AsyncMcpToolCallbackProvider(mcpClients);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public CloseableMcpAsyncClients makeAsynClientsClosable(List<McpAsyncClient> clients) {
        return new CloseableMcpAsyncClients(clients);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    McpAsyncClientConfigurer mcpAsyncClientConfigurer(ObjectProvider<McpAsyncClientCustomizer> customizerProvider) {
        return new McpAsyncClientConfigurer(customizerProvider.orderedStream().toList());
    }

    public record CloseableMcpSyncClients(List<McpSyncClient> clients) implements AutoCloseable
    {
        @Override
        public void close() {
            this.clients.forEach(McpSyncClient::close);
        }
    }

    public record CloseableMcpAsyncClients(List<McpAsyncClient> clients) implements AutoCloseable
    {
        @Override
        public void close() {
            this.clients.forEach(McpAsyncClient::close);
        }
    }
}

