/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.mcp.client;

import io.modelcontextprotocol.client.transport.ServerParameters;
import io.modelcontextprotocol.client.transport.StdioClientTransport;
import io.modelcontextprotocol.spec.ClientMcpTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.ai.autoconfigure.mcp.client.NamedClientMcpTransport;
import org.springframework.ai.autoconfigure.mcp.client.properties.McpClientCommonProperties;
import org.springframework.ai.autoconfigure.mcp.client.properties.McpStdioClientProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={McpSchema.class})
@EnableConfigurationProperties(value={McpStdioClientProperties.class, McpClientCommonProperties.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class StdioTransportAutoConfiguration {
    @Bean
    public List<NamedClientMcpTransport> stdioTransports(McpStdioClientProperties sdioProperties) {
        ArrayList<NamedClientMcpTransport> stdoiTransports = new ArrayList<NamedClientMcpTransport>();
        for (Map.Entry<String, ServerParameters> serverParameters : sdioProperties.toServerParameters().entrySet()) {
            StdioClientTransport transport = new StdioClientTransport(serverParameters.getValue());
            stdoiTransports.add(new NamedClientMcpTransport(serverParameters.getKey(), (ClientMcpTransport)transport));
        }
        return stdoiTransports;
    }
}

