/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.mcp.SyncMcpToolCallback;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.util.ToolUtils;
import org.springframework.util.CollectionUtils;

public class SyncMcpToolCallbackProvider
implements ToolCallbackProvider {
    private final List<McpSyncClient> mcpClients;

    public SyncMcpToolCallbackProvider(List<McpSyncClient> mcpClients) {
        this.mcpClients = mcpClients;
    }

    public SyncMcpToolCallbackProvider(McpSyncClient ... mcpClients) {
        this.mcpClients = List.of(mcpClients);
    }

    public ToolCallback[] getToolCallbacks() {
        ArrayList toolCallbacks = new ArrayList();
        this.mcpClients.stream().forEach(mcpClient -> toolCallbacks.addAll(mcpClient.listTools().tools().stream().map(tool -> new SyncMcpToolCallback((McpSyncClient)mcpClient, (McpSchema.Tool)tool)).toList()));
        ToolCallback[] array = toolCallbacks.toArray(new ToolCallback[0]);
        this.validateToolCallbacks(array);
        return array;
    }

    private void validateToolCallbacks(ToolCallback[] toolCallbacks) {
        List duplicateToolNames = ToolUtils.getDuplicateToolNames((FunctionCallback[])toolCallbacks);
        if (!duplicateToolNames.isEmpty()) {
            throw new IllegalStateException("Multiple tools with the same name (%s)".formatted(String.join((CharSequence)", ", duplicateToolNames)));
        }
    }

    public static List<ToolCallback> syncToolCallbacks(List<McpSyncClient> mcpClients) {
        if (CollectionUtils.isEmpty(mcpClients)) {
            return List.of();
        }
        return List.of(new SyncMcpToolCallbackProvider(mcpClients).getToolCallbacks());
    }
}

