/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MistralAiChatOptions
implements FunctionCallingOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="safe_prompt")
    private Boolean safePrompt;
    @JsonProperty(value="random_seed")
    private Integer randomSeed;
    @JsonProperty(value="response_format")
    private MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="tools")
    private List<MistralAiApi.FunctionTool> tools;
    @JsonProperty(value="tool_choice")
    private MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice;
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();
    @JsonIgnore
    private Boolean proxyToolCalls;
    @JsonIgnore
    private Map<String, Object> toolContext;

    public static Builder builder() {
        return new Builder();
    }

    public static MistralAiChatOptions fromOptions(MistralAiChatOptions fromOptions) {
        return MistralAiChatOptions.builder().model(fromOptions.getModel()).maxTokens(fromOptions.getMaxTokens()).safePrompt(fromOptions.getSafePrompt()).randomSeed(fromOptions.getRandomSeed()).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).responseFormat(fromOptions.getResponseFormat()).stop(fromOptions.getStop()).tools(fromOptions.getTools()).toolChoice(fromOptions.getToolChoice()).functionCallbacks(fromOptions.getFunctionCallbacks()).functions(fromOptions.getFunctions()).proxyToolCalls(fromOptions.getProxyToolCalls()).toolContext(fromOptions.getToolContext()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Boolean getSafePrompt() {
        return this.safePrompt;
    }

    public void setSafePrompt(Boolean safePrompt) {
        this.safePrompt = safePrompt;
    }

    public Integer getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Integer randomSeed) {
        this.randomSeed = randomSeed;
    }

    public MistralAiApi.ChatCompletionRequest.ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public List<MistralAiApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<MistralAiApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public MistralAiApi.ChatCompletionRequest.ToolChoice getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice) {
        this.toolChoice = toolChoice;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        Assert.notNull(functionCallbacks, (String)"FunctionCallbacks must not be null");
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functions) {
        Assert.notNull(functions, (String)"Function must not be null");
        this.functions = functions;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public Boolean getProxyToolCalls() {
        return this.proxyToolCalls;
    }

    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public MistralAiChatOptions copy() {
        return MistralAiChatOptions.fromOptions(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.model, this.temperature, this.topP, this.maxTokens, this.safePrompt, this.randomSeed, this.responseFormat, this.stop, this.tools, this.toolChoice, this.functionCallbacks, this.functions, this.proxyToolCalls, this.toolContext});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MistralAiChatOptions other = (MistralAiChatOptions)obj;
        return Objects.equals(this.model, other.model) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.topP, other.topP) && Objects.equals(this.maxTokens, other.maxTokens) && Objects.equals(this.safePrompt, other.safePrompt) && Objects.equals(this.randomSeed, other.randomSeed) && Objects.equals(this.responseFormat, other.responseFormat) && Objects.equals(this.stop, other.stop) && Objects.equals(this.tools, other.tools) && Objects.equals((Object)this.toolChoice, (Object)other.toolChoice) && Objects.equals(this.functionCallbacks, other.functionCallbacks) && Objects.equals(this.functions, other.functions) && Objects.equals(this.proxyToolCalls, other.proxyToolCalls) && Objects.equals(this.toolContext, other.toolContext);
    }

    public static class Builder {
        private final MistralAiChatOptions options = new MistralAiChatOptions();

        public Builder model(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder model(MistralAiApi.ChatModel chatModel) {
            this.options.setModel(chatModel.getName());
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.setMaxTokens(maxTokens);
            return this;
        }

        public Builder safePrompt(Boolean safePrompt) {
            this.options.setSafePrompt(safePrompt);
            return this;
        }

        public Builder randomSeed(Integer randomSeed) {
            this.options.setRandomSeed(randomSeed);
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.setStop(stop);
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder topP(Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder responseFormat(MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder tools(List<MistralAiApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder toolChoice(MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder functions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public Builder function(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public Builder proxyToolCalls(Boolean proxyToolCalls) {
            this.options.proxyToolCalls = proxyToolCalls;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(String model) {
            return this.model(model);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(MistralAiApi.ChatModel chatModel) {
            return this.model(chatModel);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMaxTokens(Integer maxTokens) {
            return this.maxTokens(maxTokens);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withSafePrompt(Boolean safePrompt) {
            return this.safePrompt(safePrompt);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withRandomSeed(Integer randomSeed) {
            return this.randomSeed(randomSeed);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withStop(List<String> stop) {
            return this.stop(stop);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTemperature(Double temperature) {
            return this.temperature(temperature);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTopP(Double topP) {
            return this.topP(topP);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withResponseFormat(MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat) {
            return this.responseFormat(responseFormat);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTools(List<MistralAiApi.FunctionTool> tools) {
            return this.tools(tools);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withToolChoice(MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice) {
            return this.toolChoice(toolChoice);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            return this.functionCallbacks(functionCallbacks);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunctions(Set<String> functionNames) {
            return this.functions(functionNames);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunction(String functionName) {
            return this.function(functionName);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withProxyToolCalls(Boolean proxyToolCalls) {
            return this.proxyToolCalls(proxyToolCalls);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withToolContext(Map<String, Object> toolContext) {
            return this.toolContext(toolContext);
        }

        public MistralAiChatOptions build() {
            return this.options;
        }
    }
}

