/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai.metadata;

import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.util.Assert;

public class MistralAiUsage
implements Usage {
    private final MistralAiApi.Usage usage;

    protected MistralAiUsage(MistralAiApi.Usage usage) {
        Assert.notNull((Object)usage, (String)"Mistral AI Usage must not be null");
        this.usage = usage;
    }

    public static MistralAiUsage from(MistralAiApi.Usage usage) {
        return new MistralAiUsage(usage);
    }

    protected MistralAiApi.Usage getUsage() {
        return this.usage;
    }

    public Long getPromptTokens() {
        return this.getUsage().promptTokens().longValue();
    }

    public Long getGenerationTokens() {
        return this.getUsage().completionTokens().longValue();
    }

    public Long getTotalTokens() {
        return this.getUsage().totalTokens().longValue();
    }

    public String toString() {
        return this.getUsage().toString();
    }
}

