/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MistralAiChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="safe_prompt")
    private Boolean safePrompt;
    @JsonProperty(value="random_seed")
    private Integer randomSeed;
    @JsonProperty(value="response_format")
    private MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="tools")
    private List<MistralAiApi.FunctionTool> tools;
    @JsonProperty(value="tool_choice")
    private MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice;
    @JsonIgnore
    private List<FunctionCallback> toolCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();

    public static Builder builder() {
        return new Builder();
    }

    public static MistralAiChatOptions fromOptions(MistralAiChatOptions fromOptions) {
        return MistralAiChatOptions.builder().model(fromOptions.getModel()).maxTokens(fromOptions.getMaxTokens()).safePrompt(fromOptions.getSafePrompt()).randomSeed(fromOptions.getRandomSeed()).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).responseFormat(fromOptions.getResponseFormat()).stop(fromOptions.getStop()).tools(fromOptions.getTools()).toolChoice(fromOptions.getToolChoice()).toolCallbacks(fromOptions.getToolCallbacks()).toolNames(fromOptions.getToolNames()).internalToolExecutionEnabled(fromOptions.isInternalToolExecutionEnabled()).toolContext(fromOptions.getToolContext()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Boolean getSafePrompt() {
        return this.safePrompt;
    }

    public void setSafePrompt(Boolean safePrompt) {
        this.safePrompt = safePrompt;
    }

    public Integer getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Integer randomSeed) {
        this.randomSeed = randomSeed;
    }

    public MistralAiApi.ChatCompletionRequest.ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public List<MistralAiApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<MistralAiApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public MistralAiApi.ChatCompletionRequest.ToolChoice getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice) {
        this.toolChoice = toolChoice;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonIgnore
    public List<FunctionCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<FunctionCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    @JsonIgnore
    public Boolean isInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    @Deprecated
    @JsonIgnore
    public List<FunctionCallback> getFunctionCallbacks() {
        return this.getToolCallbacks();
    }

    @Deprecated
    @JsonIgnore
    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.setToolCallbacks(functionCallbacks);
    }

    @Deprecated
    @JsonIgnore
    public Set<String> getFunctions() {
        return this.getToolNames();
    }

    @Deprecated
    @JsonIgnore
    public void setFunctions(Set<String> functionNames) {
        this.setToolNames(functionNames);
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    @Deprecated
    @JsonIgnore
    public Boolean getProxyToolCalls() {
        return this.internalToolExecutionEnabled != null ? Boolean.valueOf(this.internalToolExecutionEnabled == false) : null;
    }

    @Deprecated
    @JsonIgnore
    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.internalToolExecutionEnabled = proxyToolCalls != null ? Boolean.valueOf(proxyToolCalls == false) : null;
    }

    @JsonIgnore
    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    @JsonIgnore
    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public MistralAiChatOptions copy() {
        return MistralAiChatOptions.fromOptions(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.model, this.temperature, this.topP, this.maxTokens, this.safePrompt, this.randomSeed, this.responseFormat, this.stop, this.tools, this.toolChoice, this.toolCallbacks, this.tools, this.internalToolExecutionEnabled, this.toolContext});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MistralAiChatOptions other = (MistralAiChatOptions)obj;
        return Objects.equals(this.model, other.model) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.topP, other.topP) && Objects.equals(this.maxTokens, other.maxTokens) && Objects.equals(this.safePrompt, other.safePrompt) && Objects.equals(this.randomSeed, other.randomSeed) && Objects.equals(this.responseFormat, other.responseFormat) && Objects.equals(this.stop, other.stop) && Objects.equals(this.tools, other.tools) && Objects.equals((Object)this.toolChoice, (Object)other.toolChoice) && Objects.equals(this.toolCallbacks, other.toolCallbacks) && Objects.equals(this.toolNames, other.toolNames) && Objects.equals(this.internalToolExecutionEnabled, other.internalToolExecutionEnabled) && Objects.equals(this.toolContext, other.toolContext);
    }

    public static class Builder {
        private final MistralAiChatOptions options = new MistralAiChatOptions();

        public Builder model(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder model(MistralAiApi.ChatModel chatModel) {
            this.options.setModel(chatModel.getName());
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.setMaxTokens(maxTokens);
            return this;
        }

        public Builder safePrompt(Boolean safePrompt) {
            this.options.setSafePrompt(safePrompt);
            return this;
        }

        public Builder randomSeed(Integer randomSeed) {
            this.options.setRandomSeed(randomSeed);
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.setStop(stop);
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder topP(Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder responseFormat(MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder tools(List<MistralAiApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder toolChoice(MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder toolCallbacks(List<FunctionCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(FunctionCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        @Deprecated
        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            return this.toolCallbacks(functionCallbacks);
        }

        @Deprecated
        public Builder functions(Set<String> functionNames) {
            return this.toolNames(functionNames);
        }

        @Deprecated
        public Builder function(String functionName) {
            return this.toolNames(functionName);
        }

        @Deprecated
        public Builder proxyToolCalls(Boolean proxyToolCalls) {
            if (proxyToolCalls != null) {
                this.options.setInternalToolExecutionEnabled(proxyToolCalls == false);
            }
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public MistralAiChatOptions build() {
            return this.options;
        }
    }
}

