/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai;

import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.DefaultEmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.ai.mistralai.MistralAiEmbeddingOptions;
import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class MistralAiEmbeddingModel
extends AbstractEmbeddingModel {
    private static final Logger logger = LoggerFactory.getLogger(MistralAiEmbeddingModel.class);
    private static final EmbeddingModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultEmbeddingModelObservationConvention();
    private final MistralAiEmbeddingOptions defaultOptions;
    private final MetadataMode metadataMode;
    private final MistralAiApi mistralAiApi;
    private final RetryTemplate retryTemplate;
    private final ObservationRegistry observationRegistry;
    private EmbeddingModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public MistralAiEmbeddingModel(MistralAiApi mistralAiApi) {
        this(mistralAiApi, MetadataMode.EMBED);
    }

    public MistralAiEmbeddingModel(MistralAiApi mistralAiApi, MetadataMode metadataMode) {
        this(mistralAiApi, metadataMode, MistralAiEmbeddingOptions.builder().withModel(MistralAiApi.EmbeddingModel.EMBED.getValue()).build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public MistralAiEmbeddingModel(MistralAiApi mistralAiApi, MistralAiEmbeddingOptions options) {
        this(mistralAiApi, MetadataMode.EMBED, options, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public MistralAiEmbeddingModel(MistralAiApi mistralAiApi, MetadataMode metadataMode, MistralAiEmbeddingOptions options, RetryTemplate retryTemplate) {
        this(mistralAiApi, metadataMode, options, retryTemplate, ObservationRegistry.NOOP);
    }

    public MistralAiEmbeddingModel(MistralAiApi mistralAiApi, MetadataMode metadataMode, MistralAiEmbeddingOptions options, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)mistralAiApi, (String)"mistralAiApi must not be null");
        Assert.notNull((Object)metadataMode, (String)"metadataMode must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.mistralAiApi = mistralAiApi;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        EmbeddingRequest embeddingRequest = this.buildEmbeddingRequest(request);
        MistralAiApi.EmbeddingRequest<List<String>> apiRequest = this.createRequest(embeddingRequest);
        EmbeddingModelObservationContext observationContext = EmbeddingModelObservationContext.builder().embeddingRequest(request).provider(MistralAiApi.PROVIDER_NAME).requestOptions(embeddingRequest.getOptions()).build();
        return (EmbeddingResponse)EmbeddingModelObservationDocumentation.EMBEDDING_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            MistralAiApi.EmbeddingList apiEmbeddingResponse = (MistralAiApi.EmbeddingList)this.retryTemplate.execute(ctx -> (MistralAiApi.EmbeddingList)this.mistralAiApi.embeddings(apiRequest).getBody());
            if (apiEmbeddingResponse == null) {
                logger.warn("No embeddings returned for request: {}", (Object)request);
                return new EmbeddingResponse(List.of());
            }
            EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata(apiEmbeddingResponse.model(), (Usage)this.getDefaultUsage(apiEmbeddingResponse.usage()));
            List<Embedding> embeddings = apiEmbeddingResponse.data().stream().map(e -> new Embedding(e.embedding(), e.index())).toList();
            EmbeddingResponse embeddingResponse = new EmbeddingResponse(embeddings, metadata);
            observationContext.setResponse((Object)embeddingResponse);
            return embeddingResponse;
        });
    }

    private EmbeddingRequest buildEmbeddingRequest(EmbeddingRequest embeddingRequest) {
        MistralAiEmbeddingOptions runtimeOptions = null;
        if (embeddingRequest.getOptions() != null) {
            runtimeOptions = (MistralAiEmbeddingOptions)ModelOptionsUtils.copyToTarget((Object)embeddingRequest.getOptions(), EmbeddingOptions.class, MistralAiEmbeddingOptions.class);
        }
        MistralAiEmbeddingOptions requestOptions = (MistralAiEmbeddingOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, MistralAiEmbeddingOptions.class);
        return new EmbeddingRequest(embeddingRequest.getInstructions(), (EmbeddingOptions)requestOptions);
    }

    private DefaultUsage getDefaultUsage(MistralAiApi.Usage usage) {
        return new DefaultUsage(usage.promptTokens(), usage.completionTokens(), usage.totalTokens(), (Object)usage);
    }

    private MistralAiApi.EmbeddingRequest<List<String>> createRequest(EmbeddingRequest request) {
        MistralAiEmbeddingOptions requestOptions = (MistralAiEmbeddingOptions)request.getOptions();
        return new MistralAiApi.EmbeddingRequest<List<String>>(request.getInstructions(), requestOptions.getModel(), requestOptions.getEncodingFormat());
    }

    public float[] embed(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        return this.embed(document.getFormattedContent(this.metadataMode));
    }

    public void setObservationConvention(EmbeddingModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

