/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MistralAiChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="safe_prompt")
    private Boolean safePrompt;
    @JsonProperty(value="random_seed")
    private Integer randomSeed;
    @JsonProperty(value="response_format")
    private MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="tools")
    private List<MistralAiApi.FunctionTool> tools;
    @JsonProperty(value="tool_choice")
    private MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice;
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();

    public static Builder builder() {
        return new Builder();
    }

    public static MistralAiChatOptions fromOptions(MistralAiChatOptions fromOptions) {
        return MistralAiChatOptions.builder().model(fromOptions.getModel()).maxTokens(fromOptions.getMaxTokens()).safePrompt(fromOptions.getSafePrompt()).randomSeed(fromOptions.getRandomSeed()).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).responseFormat(fromOptions.getResponseFormat()).stop(fromOptions.getStop()).frequencyPenalty(fromOptions.getFrequencyPenalty()).presencePenalty(fromOptions.getPresencePenalty()).n(fromOptions.getN()).tools(fromOptions.getTools()).toolChoice(fromOptions.getToolChoice()).toolCallbacks(fromOptions.getToolCallbacks()).toolNames(fromOptions.getToolNames()).internalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled()).toolContext(fromOptions.getToolContext()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Boolean getSafePrompt() {
        return this.safePrompt;
    }

    public void setSafePrompt(Boolean safePrompt) {
        this.safePrompt = safePrompt;
    }

    public Integer getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Integer randomSeed) {
        this.randomSeed = randomSeed;
    }

    public MistralAiApi.ChatCompletionRequest.ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public List<MistralAiApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<MistralAiApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public MistralAiApi.ChatCompletionRequest.ToolChoice getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice) {
        this.toolChoice = toolChoice;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    @JsonIgnore
    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    @JsonIgnore
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    @JsonIgnore
    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    @JsonIgnore
    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public MistralAiChatOptions copy() {
        return MistralAiChatOptions.fromOptions(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.model, this.temperature, this.topP, this.maxTokens, this.safePrompt, this.randomSeed, this.responseFormat, this.stop, this.frequencyPenalty, this.presencePenalty, this.n, this.tools, this.toolChoice, this.toolCallbacks, this.tools, this.internalToolExecutionEnabled, this.toolContext});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MistralAiChatOptions other = (MistralAiChatOptions)obj;
        return Objects.equals(this.model, other.model) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.topP, other.topP) && Objects.equals(this.maxTokens, other.maxTokens) && Objects.equals(this.safePrompt, other.safePrompt) && Objects.equals(this.randomSeed, other.randomSeed) && Objects.equals(this.responseFormat, other.responseFormat) && Objects.equals(this.stop, other.stop) && Objects.equals(this.frequencyPenalty, other.frequencyPenalty) && Objects.equals(this.presencePenalty, other.presencePenalty) && Objects.equals(this.n, other.n) && Objects.equals(this.tools, other.tools) && Objects.equals((Object)this.toolChoice, (Object)other.toolChoice) && Objects.equals(this.toolCallbacks, other.toolCallbacks) && Objects.equals(this.toolNames, other.toolNames) && Objects.equals(this.internalToolExecutionEnabled, other.internalToolExecutionEnabled) && Objects.equals(this.toolContext, other.toolContext);
    }

    public static class Builder {
        private final MistralAiChatOptions options = new MistralAiChatOptions();

        public Builder model(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder model(MistralAiApi.ChatModel chatModel) {
            this.options.setModel(chatModel.getName());
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.setMaxTokens(maxTokens);
            return this;
        }

        public Builder safePrompt(Boolean safePrompt) {
            this.options.setSafePrompt(safePrompt);
            return this;
        }

        public Builder randomSeed(Integer randomSeed) {
            this.options.setRandomSeed(randomSeed);
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.setStop(stop);
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder n(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder topP(Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder responseFormat(MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder tools(List<MistralAiApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder toolChoice(MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public MistralAiChatOptions build() {
            return this.options;
        }
    }
}

