/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.content.Media;
import org.springframework.ai.content.MediaContent;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class UserMessage
extends AbstractMessage
implements MediaContent {
    protected final List<Media> media;

    public UserMessage(String textContent) {
        this(MessageType.USER, textContent, new ArrayList<Media>(), Map.of());
    }

    public UserMessage(Resource resource) {
        super(MessageType.USER, resource, Map.of());
        this.media = new ArrayList<Media>();
    }

    public UserMessage(String textContent, List<Media> media) {
        this(MessageType.USER, textContent, media, Map.of());
    }

    public UserMessage(String textContent, Media ... media) {
        this(textContent, Arrays.asList(media));
    }

    public UserMessage(String textContent, Collection<Media> mediaList, Map<String, Object> metadata) {
        this(MessageType.USER, textContent, mediaList, metadata);
    }

    public UserMessage(MessageType messageType, String textContent, Collection<Media> media, Map<String, Object> metadata) {
        super(messageType, textContent, metadata);
        Assert.notNull(media, (String)"media data must not be null");
        this.media = new ArrayList<Media>(media);
    }

    public String toString() {
        return "UserMessage{content='" + this.getText() + "', properties=" + String.valueOf(this.metadata) + ", messageType=" + String.valueOf((Object)this.messageType) + "}";
    }

    public List<Media> getMedia() {
        return this.media;
    }

    @Override
    public String getText() {
        return this.textContent;
    }
}

