/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Content;
import org.springframework.ai.observation.ObservabilityHelper;
import org.springframework.util.CollectionUtils;

public class ChatModelPromptContentObservationHandler
implements ObservationHandler<ChatModelObservationContext> {
    private static final Logger logger = LoggerFactory.getLogger(ChatModelPromptContentObservationHandler.class);

    public void onStop(ChatModelObservationContext context) {
        logger.debug("Chat Model Prompt Content:\n{}", (Object)ObservabilityHelper.concatenateStrings(this.prompt(context)));
    }

    private List<String> prompt(ChatModelObservationContext context) {
        if (CollectionUtils.isEmpty((Collection)((Prompt)context.getRequest()).getInstructions())) {
            return List.of();
        }
        return ((Prompt)context.getRequest()).getInstructions().stream().map(Content::getText).toList();
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ChatModelObservationContext;
    }
}

