/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.prompt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.ModelRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class Prompt
implements ModelRequest<List<Message>> {
    private final List<Message> messages;
    @Nullable
    private ChatOptions chatOptions;

    public Prompt(String contents) {
        this((Message)new UserMessage(contents));
    }

    public Prompt(Message message) {
        this(Collections.singletonList(message));
    }

    public Prompt(List<Message> messages) {
        this(messages, null);
    }

    public Prompt(Message ... messages) {
        this(Arrays.asList(messages), null);
    }

    public Prompt(String contents, @Nullable ChatOptions chatOptions) {
        this((Message)new UserMessage(contents), chatOptions);
    }

    public Prompt(Message message, @Nullable ChatOptions chatOptions) {
        this(Collections.singletonList(message), chatOptions);
    }

    public Prompt(List<Message> messages, @Nullable ChatOptions chatOptions) {
        Assert.notNull(messages, (String)"messages cannot be null");
        Assert.noNullElements(messages, (String)"messages cannot contain null elements");
        this.messages = messages;
        this.chatOptions = chatOptions;
    }

    public String getContents() {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = this.getInstructions().iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            sb.append(message.getText());
        }
        return sb.toString();
    }

    @Override
    @Nullable
    public ChatOptions getOptions() {
        return this.chatOptions;
    }

    @Override
    public List<Message> getInstructions() {
        return this.messages;
    }

    public SystemMessage getSystemMessage() {
        for (int i = 0; i <= this.messages.size() - 1; ++i) {
            Message message = this.messages.get(i);
            if (!(message instanceof SystemMessage)) continue;
            SystemMessage systemMessage = (SystemMessage)message;
            return systemMessage;
        }
        return new SystemMessage("");
    }

    public UserMessage getUserMessage() {
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            Message message = this.messages.get(i);
            if (!(message instanceof UserMessage)) continue;
            UserMessage userMessage = (UserMessage)message;
            return userMessage;
        }
        return new UserMessage("");
    }

    public List<UserMessage> getUserMessages() {
        ArrayList<UserMessage> userMessages = new ArrayList<UserMessage>();
        for (Message message : this.messages) {
            if (!(message instanceof UserMessage)) continue;
            UserMessage userMessage = (UserMessage)message;
            userMessages.add(userMessage);
        }
        return userMessages;
    }

    public String toString() {
        return "Prompt{messages=" + String.valueOf(this.messages) + ", modelOptions=" + String.valueOf(this.chatOptions) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Prompt)) {
            return false;
        }
        Prompt prompt = (Prompt)o;
        return Objects.equals(this.messages, prompt.messages) && Objects.equals(this.chatOptions, prompt.chatOptions);
    }

    public int hashCode() {
        return Objects.hash(this.messages, this.chatOptions);
    }

    public Prompt copy() {
        return new Prompt(this.instructionsCopy(), null == this.chatOptions ? null : (ChatOptions)this.chatOptions.copy());
    }

    private List<Message> instructionsCopy() {
        ArrayList<Message> messagesCopy = new ArrayList<Message>();
        this.messages.forEach(message -> {
            if (message instanceof UserMessage) {
                UserMessage userMessage = (UserMessage)message;
                messagesCopy.add(userMessage.copy());
            } else if (message instanceof SystemMessage) {
                SystemMessage systemMessage = (SystemMessage)message;
                messagesCopy.add(systemMessage.copy());
            } else if (message instanceof AssistantMessage) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                messagesCopy.add(AssistantMessage.builder().content(assistantMessage.getText()).properties(assistantMessage.getMetadata()).toolCalls(assistantMessage.getToolCalls()).build());
            } else if (message instanceof ToolResponseMessage) {
                ToolResponseMessage toolResponseMessage = (ToolResponseMessage)message;
                messagesCopy.add(new ToolResponseMessage(new ArrayList<ToolResponseMessage.ToolResponse>(toolResponseMessage.getResponses()), new HashMap<String, Object>(toolResponseMessage.getMetadata())));
            } else {
                throw new IllegalArgumentException("Unsupported message type: " + message.getClass().getName());
            }
        });
        return messagesCopy;
    }

    public Prompt augmentSystemMessage(Function<SystemMessage, SystemMessage> systemMessageAugmenter) {
        ArrayList<Message> messagesCopy = new ArrayList<Message>(this.messages);
        boolean found = false;
        for (int i = 0; i < messagesCopy.size(); ++i) {
            Message message = messagesCopy.get(i);
            if (!(message instanceof SystemMessage)) continue;
            SystemMessage systemMessage = (SystemMessage)message;
            messagesCopy.set(i, systemMessageAugmenter.apply(systemMessage));
            found = true;
            break;
        }
        if (!found) {
            messagesCopy.add(0, systemMessageAugmenter.apply(new SystemMessage("")));
        }
        return new Prompt(messagesCopy, null == this.chatOptions ? null : (ChatOptions)this.chatOptions.copy());
    }

    public Prompt augmentSystemMessage(String newSystemText) {
        return this.augmentSystemMessage((SystemMessage systemMessage) -> systemMessage.mutate().text(newSystemText).build());
    }

    public Prompt augmentUserMessage(Function<UserMessage, UserMessage> userMessageAugmenter) {
        ArrayList<Message> messagesCopy = new ArrayList<Message>(this.messages);
        for (int i = messagesCopy.size() - 1; i >= 0; --i) {
            Message message = messagesCopy.get(i);
            if (message instanceof UserMessage) {
                UserMessage userMessage = (UserMessage)message;
                messagesCopy.set(i, userMessageAugmenter.apply(userMessage));
                break;
            }
            if (i != 0) continue;
            messagesCopy.add(userMessageAugmenter.apply(new UserMessage("")));
        }
        return new Prompt(messagesCopy, null == this.chatOptions ? null : (ChatOptions)this.chatOptions.copy());
    }

    public Prompt augmentUserMessage(String newUserText) {
        return this.augmentUserMessage((UserMessage userMessage) -> userMessage.mutate().text(newUserText).build());
    }

    public Builder mutate() {
        Builder builder = new Builder().messages(this.instructionsCopy());
        if (this.chatOptions != null) {
            builder.chatOptions((ChatOptions)this.chatOptions.copy());
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String content;
        @Nullable
        private List<Message> messages;
        @Nullable
        private ChatOptions chatOptions;

        public Builder content(@Nullable String content) {
            this.content = content;
            return this;
        }

        public Builder messages(Message ... messages) {
            if (messages != null) {
                this.messages = Arrays.asList(messages);
            }
            return this;
        }

        public Builder messages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public Builder chatOptions(ChatOptions chatOptions) {
            this.chatOptions = chatOptions;
            return this;
        }

        public Prompt build() {
            if (StringUtils.hasText((String)this.content) && !CollectionUtils.isEmpty(this.messages)) {
                throw new IllegalArgumentException("content and messages cannot be set at the same time");
            }
            if (StringUtils.hasText((String)this.content)) {
                this.messages = List.of(new UserMessage(this.content));
            }
            return new Prompt(this.messages, this.chatOptions);
        }
    }
}

