/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.ollama.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.ollama.api.OllamaModel;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OllamaOptions
implements FunctionCallingOptions,
EmbeddingOptions {
    private static final List<String> NON_SUPPORTED_FIELDS = List.of("model", "format", "keep_alive", "truncate");
    @JsonProperty(value="numa")
    private Boolean useNUMA;
    @JsonProperty(value="num_ctx")
    private Integer numCtx;
    @JsonProperty(value="num_batch")
    private Integer numBatch;
    @JsonProperty(value="num_gpu")
    private Integer numGPU;
    @JsonProperty(value="main_gpu")
    private Integer mainGPU;
    @JsonProperty(value="low_vram")
    private Boolean lowVRAM;
    @JsonProperty(value="f16_kv")
    private Boolean f16KV;
    @JsonProperty(value="logits_all")
    private Boolean logitsAll;
    @JsonProperty(value="vocab_only")
    private Boolean vocabOnly;
    @JsonProperty(value="use_mmap")
    private Boolean useMMap;
    @JsonProperty(value="use_mlock")
    private Boolean useMLock;
    @JsonProperty(value="num_thread")
    private Integer numThread;
    @JsonProperty(value="num_keep")
    private Integer numKeep;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="num_predict")
    private Integer numPredict;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="tfs_z")
    private Float tfsZ;
    @JsonProperty(value="typical_p")
    private Float typicalP;
    @JsonProperty(value="repeat_last_n")
    private Integer repeatLastN;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="repeat_penalty")
    private Double repeatPenalty;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="mirostat")
    private Integer mirostat;
    @JsonProperty(value="mirostat_tau")
    private Float mirostatTau;
    @JsonProperty(value="mirostat_eta")
    private Float mirostatEta;
    @JsonProperty(value="penalize_newline")
    private Boolean penalizeNewline;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="format")
    private Object format;
    @JsonProperty(value="keep_alive")
    private String keepAlive;
    @JsonProperty(value="truncate")
    private Boolean truncate;
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();
    @JsonIgnore
    private Boolean proxyToolCalls;
    @JsonIgnore
    private Map<String, Object> toolContext;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public static OllamaOptions create() {
        return new OllamaOptions();
    }

    public static Map<String, Object> filterNonSupportedFields(Map<String, Object> options) {
        return options.entrySet().stream().filter(e -> !NON_SUPPORTED_FIELDS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static OllamaOptions fromOptions(OllamaOptions fromOptions) {
        return OllamaOptions.builder().model(fromOptions.getModel()).format(fromOptions.getFormat()).keepAlive(fromOptions.getKeepAlive()).truncate(fromOptions.getTruncate()).useNUMA(fromOptions.getUseNUMA()).numCtx(fromOptions.getNumCtx()).numBatch(fromOptions.getNumBatch()).numGPU(fromOptions.getNumGPU()).mainGPU(fromOptions.getMainGPU()).lowVRAM(fromOptions.getLowVRAM()).f16KV(fromOptions.getF16KV()).logitsAll(fromOptions.getLogitsAll()).vocabOnly(fromOptions.getVocabOnly()).useMMap(fromOptions.getUseMMap()).useMLock(fromOptions.getUseMLock()).numThread(fromOptions.getNumThread()).numKeep(fromOptions.getNumKeep()).seed(fromOptions.getSeed()).numPredict(fromOptions.getNumPredict()).topK(fromOptions.getTopK()).topP(fromOptions.getTopP()).tfsZ(fromOptions.getTfsZ()).typicalP(fromOptions.getTypicalP()).repeatLastN(fromOptions.getRepeatLastN()).temperature(fromOptions.getTemperature()).repeatPenalty(fromOptions.getRepeatPenalty()).presencePenalty(fromOptions.getPresencePenalty()).frequencyPenalty(fromOptions.getFrequencyPenalty()).mirostat(fromOptions.getMirostat()).mirostatTau(fromOptions.getMirostatTau()).mirostatEta(fromOptions.getMirostatEta()).penalizeNewline(fromOptions.getPenalizeNewline()).stop(fromOptions.getStop()).functions(fromOptions.getFunctions()).proxyToolCalls(fromOptions.getProxyToolCalls()).functionCallbacks(fromOptions.getFunctionCallbacks()).toolContext(fromOptions.getToolContext()).build();
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions build() {
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withModel(String model) {
        this.model = model;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withModel(OllamaModel model) {
        this.model = model.getName();
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withFormat(Object format) {
        this.format = format;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withKeepAlive(String keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withTruncate(Boolean truncate) {
        this.truncate = truncate;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withUseNUMA(Boolean useNUMA) {
        this.useNUMA = useNUMA;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withNumCtx(Integer numCtx) {
        this.numCtx = numCtx;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withNumBatch(Integer numBatch) {
        this.numBatch = numBatch;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withNumGPU(Integer numGPU) {
        this.numGPU = numGPU;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withMainGPU(Integer mainGPU) {
        this.mainGPU = mainGPU;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withLowVRAM(Boolean lowVRAM) {
        this.lowVRAM = lowVRAM;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withF16KV(Boolean f16KV) {
        this.f16KV = f16KV;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withLogitsAll(Boolean logitsAll) {
        this.logitsAll = logitsAll;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withVocabOnly(Boolean vocabOnly) {
        this.vocabOnly = vocabOnly;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withUseMMap(Boolean useMMap) {
        this.useMMap = useMMap;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withUseMLock(Boolean useMLock) {
        this.useMLock = useMLock;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withNumThread(Integer numThread) {
        this.numThread = numThread;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withNumKeep(Integer numKeep) {
        this.numKeep = numKeep;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withSeed(Integer seed) {
        this.seed = seed;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withNumPredict(Integer numPredict) {
        this.numPredict = numPredict;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withTopK(Integer topK) {
        this.topK = topK;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withTfsZ(Float tfsZ) {
        this.tfsZ = tfsZ;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withTypicalP(Float typicalP) {
        this.typicalP = typicalP;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withRepeatLastN(Integer repeatLastN) {
        this.repeatLastN = repeatLastN;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withRepeatPenalty(Double repeatPenalty) {
        this.repeatPenalty = repeatPenalty;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withMirostat(Integer mirostat) {
        this.mirostat = mirostat;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withMirostatTau(Float mirostatTau) {
        this.mirostatTau = mirostatTau;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withMirostatEta(Float mirostatEta) {
        this.mirostatEta = mirostatEta;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withPenalizeNewline(Boolean penalizeNewline) {
        this.penalizeNewline = penalizeNewline;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withStop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withFunctions(Set<String> functions) {
        this.functions = functions;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withFunction(String functionName) {
        Assert.hasText((String)functionName, (String)"Function name must not be empty");
        this.functions.add(functionName);
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
        return this;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M5")
    public OllamaOptions withToolContext(Map<String, Object> toolContext) {
        if (this.toolContext == null) {
            this.toolContext = toolContext;
        } else {
            this.toolContext.putAll(toolContext);
        }
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Object getFormat() {
        return this.format;
    }

    public void setFormat(Object format) {
        this.format = format;
    }

    public String getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(String keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Boolean getUseNUMA() {
        return this.useNUMA;
    }

    public void setUseNUMA(Boolean useNUMA) {
        this.useNUMA = useNUMA;
    }

    public Integer getNumCtx() {
        return this.numCtx;
    }

    public void setNumCtx(Integer numCtx) {
        this.numCtx = numCtx;
    }

    public Integer getNumBatch() {
        return this.numBatch;
    }

    public void setNumBatch(Integer numBatch) {
        this.numBatch = numBatch;
    }

    public Integer getNumGPU() {
        return this.numGPU;
    }

    public void setNumGPU(Integer numGPU) {
        this.numGPU = numGPU;
    }

    public Integer getMainGPU() {
        return this.mainGPU;
    }

    public void setMainGPU(Integer mainGPU) {
        this.mainGPU = mainGPU;
    }

    public Boolean getLowVRAM() {
        return this.lowVRAM;
    }

    public void setLowVRAM(Boolean lowVRAM) {
        this.lowVRAM = lowVRAM;
    }

    public Boolean getF16KV() {
        return this.f16KV;
    }

    public void setF16KV(Boolean f16kv) {
        this.f16KV = f16kv;
    }

    public Boolean getLogitsAll() {
        return this.logitsAll;
    }

    public void setLogitsAll(Boolean logitsAll) {
        this.logitsAll = logitsAll;
    }

    public Boolean getVocabOnly() {
        return this.vocabOnly;
    }

    public void setVocabOnly(Boolean vocabOnly) {
        this.vocabOnly = vocabOnly;
    }

    public Boolean getUseMMap() {
        return this.useMMap;
    }

    public void setUseMMap(Boolean useMMap) {
        this.useMMap = useMMap;
    }

    public Boolean getUseMLock() {
        return this.useMLock;
    }

    public void setUseMLock(Boolean useMLock) {
        this.useMLock = useMLock;
    }

    public Integer getNumThread() {
        return this.numThread;
    }

    public void setNumThread(Integer numThread) {
        this.numThread = numThread;
    }

    public Integer getNumKeep() {
        return this.numKeep;
    }

    public void setNumKeep(Integer numKeep) {
        this.numKeep = numKeep;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    @JsonIgnore
    public Integer getMaxTokens() {
        return this.getNumPredict();
    }

    @JsonIgnore
    public void setMaxTokens(Integer maxTokens) {
        this.setNumPredict(maxTokens);
    }

    public Integer getNumPredict() {
        return this.numPredict;
    }

    public void setNumPredict(Integer numPredict) {
        this.numPredict = numPredict;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Float getTfsZ() {
        return this.tfsZ;
    }

    public void setTfsZ(Float tfsZ) {
        this.tfsZ = tfsZ;
    }

    public Float getTypicalP() {
        return this.typicalP;
    }

    public void setTypicalP(Float typicalP) {
        this.typicalP = typicalP;
    }

    public Integer getRepeatLastN() {
        return this.repeatLastN;
    }

    public void setRepeatLastN(Integer repeatLastN) {
        this.repeatLastN = repeatLastN;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getRepeatPenalty() {
        return this.repeatPenalty;
    }

    public void setRepeatPenalty(Double repeatPenalty) {
        this.repeatPenalty = repeatPenalty;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Integer getMirostat() {
        return this.mirostat;
    }

    public void setMirostat(Integer mirostat) {
        this.mirostat = mirostat;
    }

    public Float getMirostatTau() {
        return this.mirostatTau;
    }

    public void setMirostatTau(Float mirostatTau) {
        this.mirostatTau = mirostatTau;
    }

    public Float getMirostatEta() {
        return this.mirostatEta;
    }

    public void setMirostatEta(Float mirostatEta) {
        this.mirostatEta = mirostatEta;
    }

    public Boolean getPenalizeNewline() {
        return this.penalizeNewline;
    }

    public void setPenalizeNewline(Boolean penalizeNewline) {
        this.penalizeNewline = penalizeNewline;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Boolean getTruncate() {
        return this.truncate;
    }

    public void setTruncate(Boolean truncate) {
        this.truncate = truncate;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functions) {
        this.functions = functions;
    }

    @JsonIgnore
    public Integer getDimensions() {
        return null;
    }

    public Boolean getProxyToolCalls() {
        return this.proxyToolCalls;
    }

    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public Map<String, Object> toMap() {
        return ModelOptionsUtils.objectToMap((Object)this);
    }

    public OllamaOptions copy() {
        return OllamaOptions.fromOptions(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OllamaOptions that = (OllamaOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.format, that.format) && Objects.equals(this.keepAlive, that.keepAlive) && Objects.equals(this.truncate, that.truncate) && Objects.equals(this.useNUMA, that.useNUMA) && Objects.equals(this.numCtx, that.numCtx) && Objects.equals(this.numBatch, that.numBatch) && Objects.equals(this.numGPU, that.numGPU) && Objects.equals(this.mainGPU, that.mainGPU) && Objects.equals(this.lowVRAM, that.lowVRAM) && Objects.equals(this.f16KV, that.f16KV) && Objects.equals(this.logitsAll, that.logitsAll) && Objects.equals(this.vocabOnly, that.vocabOnly) && Objects.equals(this.useMMap, that.useMMap) && Objects.equals(this.useMLock, that.useMLock) && Objects.equals(this.numThread, that.numThread) && Objects.equals(this.numKeep, that.numKeep) && Objects.equals(this.seed, that.seed) && Objects.equals(this.numPredict, that.numPredict) && Objects.equals(this.topK, that.topK) && Objects.equals(this.topP, that.topP) && Objects.equals(this.tfsZ, that.tfsZ) && Objects.equals(this.typicalP, that.typicalP) && Objects.equals(this.repeatLastN, that.repeatLastN) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.repeatPenalty, that.repeatPenalty) && Objects.equals(this.presencePenalty, that.presencePenalty) && Objects.equals(this.frequencyPenalty, that.frequencyPenalty) && Objects.equals(this.mirostat, that.mirostat) && Objects.equals(this.mirostatTau, that.mirostatTau) && Objects.equals(this.mirostatEta, that.mirostatEta) && Objects.equals(this.penalizeNewline, that.penalizeNewline) && Objects.equals(this.stop, that.stop) && Objects.equals(this.functionCallbacks, that.functionCallbacks) && Objects.equals(this.proxyToolCalls, that.proxyToolCalls) && Objects.equals(this.functions, that.functions) && Objects.equals(this.toolContext, that.toolContext);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.format, this.keepAlive, this.truncate, this.useNUMA, this.numCtx, this.numBatch, this.numGPU, this.mainGPU, this.lowVRAM, this.f16KV, this.logitsAll, this.vocabOnly, this.useMMap, this.useMLock, this.numThread, this.numKeep, this.seed, this.numPredict, this.topK, this.topP, this.tfsZ, this.typicalP, this.repeatLastN, this.temperature, this.repeatPenalty, this.presencePenalty, this.frequencyPenalty, this.mirostat, this.mirostatTau, this.mirostatEta, this.penalizeNewline, this.stop, this.functionCallbacks, this.functions, this.proxyToolCalls, this.toolContext);
    }

    public static class Builder {
        private final OllamaOptions options = new OllamaOptions();

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder model(OllamaModel model) {
            this.options.model = model.getName();
            return this;
        }

        public Builder format(Object format) {
            this.options.format = format;
            return this;
        }

        public Builder keepAlive(String keepAlive) {
            this.options.keepAlive = keepAlive;
            return this;
        }

        public Builder truncate(Boolean truncate) {
            this.options.truncate = truncate;
            return this;
        }

        public Builder useNUMA(Boolean useNUMA) {
            this.options.useNUMA = useNUMA;
            return this;
        }

        public Builder numCtx(Integer numCtx) {
            this.options.numCtx = numCtx;
            return this;
        }

        public Builder numBatch(Integer numBatch) {
            this.options.numBatch = numBatch;
            return this;
        }

        public Builder numGPU(Integer numGPU) {
            this.options.numGPU = numGPU;
            return this;
        }

        public Builder mainGPU(Integer mainGPU) {
            this.options.mainGPU = mainGPU;
            return this;
        }

        public Builder lowVRAM(Boolean lowVRAM) {
            this.options.lowVRAM = lowVRAM;
            return this;
        }

        public Builder f16KV(Boolean f16KV) {
            this.options.f16KV = f16KV;
            return this;
        }

        public Builder logitsAll(Boolean logitsAll) {
            this.options.logitsAll = logitsAll;
            return this;
        }

        public Builder vocabOnly(Boolean vocabOnly) {
            this.options.vocabOnly = vocabOnly;
            return this;
        }

        public Builder useMMap(Boolean useMMap) {
            this.options.useMMap = useMMap;
            return this;
        }

        public Builder useMLock(Boolean useMLock) {
            this.options.useMLock = useMLock;
            return this;
        }

        public Builder numThread(Integer numThread) {
            this.options.numThread = numThread;
            return this;
        }

        public Builder numKeep(Integer numKeep) {
            this.options.numKeep = numKeep;
            return this;
        }

        public Builder seed(Integer seed) {
            this.options.seed = seed;
            return this;
        }

        public Builder numPredict(Integer numPredict) {
            this.options.numPredict = numPredict;
            return this;
        }

        public Builder topK(Integer topK) {
            this.options.topK = topK;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder tfsZ(Float tfsZ) {
            this.options.tfsZ = tfsZ;
            return this;
        }

        public Builder typicalP(Float typicalP) {
            this.options.typicalP = typicalP;
            return this;
        }

        public Builder repeatLastN(Integer repeatLastN) {
            this.options.repeatLastN = repeatLastN;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder repeatPenalty(Double repeatPenalty) {
            this.options.repeatPenalty = repeatPenalty;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder mirostat(Integer mirostat) {
            this.options.mirostat = mirostat;
            return this;
        }

        public Builder mirostatTau(Float mirostatTau) {
            this.options.mirostatTau = mirostatTau;
            return this;
        }

        public Builder mirostatEta(Float mirostatEta) {
            this.options.mirostatEta = mirostatEta;
            return this;
        }

        public Builder penalizeNewline(Boolean penalizeNewline) {
            this.options.penalizeNewline = penalizeNewline;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder functions(Set<String> functions) {
            Assert.notNull(functions, (String)"Function names must not be null");
            this.options.functions = functions;
            return this;
        }

        public Builder function(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public Builder proxyToolCalls(Boolean proxyToolCalls) {
            this.options.proxyToolCalls = proxyToolCalls;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(String model) {
            return this.model(model);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(OllamaModel model) {
            return this.model(model);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFormat(Object format) {
            return this.format(format);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withKeepAlive(String keepAlive) {
            return this.keepAlive(keepAlive);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTruncate(Boolean truncate) {
            return this.truncate(truncate);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withUseNUMA(Boolean useNUMA) {
            return this.useNUMA(useNUMA);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withNumCtx(Integer numCtx) {
            return this.numCtx(numCtx);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withNumBatch(Integer numBatch) {
            return this.numBatch(numBatch);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withNumGPU(Integer numGPU) {
            return this.numGPU(numGPU);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMainGPU(Integer mainGPU) {
            return this.mainGPU(mainGPU);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withLowVRAM(Boolean lowVRAM) {
            return this.lowVRAM(lowVRAM);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withF16KV(Boolean f16KV) {
            return this.f16KV(f16KV);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withLogitsAll(Boolean logitsAll) {
            return this.logitsAll(logitsAll);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withVocabOnly(Boolean vocabOnly) {
            return this.vocabOnly(vocabOnly);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withUseMMap(Boolean useMMap) {
            return this.useMMap(useMMap);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withUseMLock(Boolean useMLock) {
            return this.useMLock(useMLock);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withNumThread(Integer numThread) {
            return this.numThread(numThread);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withNumKeep(Integer numKeep) {
            return this.numKeep(numKeep);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withSeed(Integer seed) {
            return this.seed(seed);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withNumPredict(Integer numPredict) {
            return this.numPredict(numPredict);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTopK(Integer topK) {
            return this.topK(topK);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTopP(Double topP) {
            return this.topP(topP);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTfsZ(Float tfsZ) {
            return this.tfsZ(tfsZ);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTypicalP(Float typicalP) {
            return this.typicalP(typicalP);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withRepeatLastN(Integer repeatLastN) {
            return this.repeatLastN(repeatLastN);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTemperature(Double temperature) {
            return this.temperature(temperature);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withRepeatPenalty(Double repeatPenalty) {
            return this.repeatPenalty(repeatPenalty);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withPresencePenalty(Double presencePenalty) {
            return this.presencePenalty(presencePenalty);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFrequencyPenalty(Double frequencyPenalty) {
            return this.frequencyPenalty(frequencyPenalty);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMirostat(Integer mirostat) {
            return this.mirostat(mirostat);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMirostatTau(Float mirostatTau) {
            return this.mirostatTau(mirostatTau);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMirostatEta(Float mirostatEta) {
            return this.mirostatEta(mirostatEta);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withPenalizeNewline(Boolean penalizeNewline) {
            return this.penalizeNewline(penalizeNewline);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withStop(List<String> stop) {
            return this.stop(stop);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            return this.functionCallbacks(functionCallbacks);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunctions(Set<String> functions) {
            return this.functions(functions);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunction(String functionName) {
            return this.function(functionName);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withProxyToolCalls(Boolean proxyToolCalls) {
            return this.proxyToolCalls(proxyToolCalls);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withToolContext(Map<String, Object> toolContext) {
            return this.toolContext(toolContext);
        }

        public OllamaOptions build() {
            return this.options;
        }
    }
}

