/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.ollama.metadata;

import java.util.Optional;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.util.Assert;

public class OllamaEmbeddingUsage
implements Usage {
    protected static final String AI_USAGE_STRING = "{ promptTokens: %1$d, generationTokens: %2$d, totalTokens: %3$d }";
    private Long promptTokens;

    public OllamaEmbeddingUsage(OllamaApi.EmbeddingsResponse response) {
        this.promptTokens = Optional.ofNullable(response.promptEvalCount()).map(Integer::longValue).orElse(0L);
    }

    public static OllamaEmbeddingUsage from(OllamaApi.EmbeddingsResponse response) {
        Assert.notNull((Object)response, (String)"OllamaApi.EmbeddingsResponse must not be null");
        return new OllamaEmbeddingUsage(response);
    }

    public Long getPromptTokens() {
        return this.promptTokens;
    }

    public Long getGenerationTokens() {
        return 0L;
    }

    public String toString() {
        return AI_USAGE_STRING.formatted(this.getPromptTokens(), this.getGenerationTokens(), this.getTotalTokens());
    }
}

