/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.ollama.api;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.util.CollectionUtils;

public final class OllamaApiHelper {
    private OllamaApiHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static boolean isStreamingToolCall(OllamaApi.ChatResponse ollamaChatResponse) {
        if (ollamaChatResponse == null || ollamaChatResponse.message() == null || ollamaChatResponse.message().toolCalls() == null) {
            return false;
        }
        return !CollectionUtils.isEmpty(ollamaChatResponse.message().toolCalls());
    }

    public static boolean isStreamingDone(OllamaApi.ChatResponse ollamaChatResponse) {
        if (ollamaChatResponse == null) {
            return false;
        }
        return ollamaChatResponse.done() != false && ollamaChatResponse.doneReason().equals("stop");
    }

    public static OllamaApi.ChatResponse merge(OllamaApi.ChatResponse previous, OllamaApi.ChatResponse current) {
        String model = OllamaApiHelper.merge(previous.model(), current.model());
        Instant createdAt = OllamaApiHelper.merge(previous.createdAt(), current.createdAt());
        OllamaApi.Message message = OllamaApiHelper.merge(previous.message(), current.message());
        String doneReason = current.doneReason() != null ? current.doneReason() : previous.doneReason();
        Boolean done = current.done() != null ? current.done() : previous.done();
        Long totalDuration = OllamaApiHelper.merge(previous.totalDuration(), current.totalDuration());
        Long loadDuration = OllamaApiHelper.merge(previous.loadDuration(), current.loadDuration());
        Integer promptEvalCount = OllamaApiHelper.merge(previous.promptEvalCount(), current.promptEvalCount());
        Long promptEvalDuration = OllamaApiHelper.merge(previous.promptEvalDuration(), current.promptEvalDuration());
        Integer evalCount = OllamaApiHelper.merge(previous.evalCount(), current.evalCount());
        Long evalDuration = OllamaApiHelper.merge(previous.evalDuration(), current.evalDuration());
        return new OllamaApi.ChatResponse(model, createdAt, message, doneReason, done, totalDuration, loadDuration, promptEvalCount, promptEvalDuration, evalCount, evalDuration);
    }

    private static OllamaApi.Message merge(OllamaApi.Message previous, OllamaApi.Message current) {
        String content = OllamaApiHelper.mergeContent(previous, current);
        OllamaApi.Message.Role role = current.role() != null ? current.role() : previous.role();
        role = role != null ? role : OllamaApi.Message.Role.ASSISTANT;
        List<String> images = OllamaApiHelper.mergeImages(previous, current);
        List<OllamaApi.Message.ToolCall> toolCalls = OllamaApiHelper.mergeToolCall(previous, current);
        return OllamaApi.Message.builder(role).content(content).images(images).toolCalls(toolCalls).build();
    }

    private static Instant merge(Instant previous, Instant current) {
        return current != null ? current : previous;
    }

    private static Integer merge(Integer previous, Integer current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        return previous + current;
    }

    private static Long merge(Long previous, Long current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        return previous + current;
    }

    private static String merge(String previous, String current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        return previous + current;
    }

    private static String mergeContent(OllamaApi.Message previous, OllamaApi.Message current) {
        if (previous == null || previous.content() == null) {
            return current != null ? current.content() : null;
        }
        if (current == null || current.content() == null) {
            return previous != null ? previous.content() : null;
        }
        return previous.content() + current.content();
    }

    private static List<OllamaApi.Message.ToolCall> mergeToolCall(OllamaApi.Message previous, OllamaApi.Message current) {
        if (previous == null) {
            return current != null ? current.toolCalls() : null;
        }
        if (current == null) {
            return previous.toolCalls();
        }
        return OllamaApiHelper.merge(previous.toolCalls(), current.toolCalls());
    }

    private static List<String> mergeImages(OllamaApi.Message previous, OllamaApi.Message current) {
        if (previous == null) {
            return current != null ? current.images() : null;
        }
        if (current == null) {
            return previous.images();
        }
        return OllamaApiHelper.merge(previous.images(), current.images());
    }

    private static <T> List<T> merge(List<T> previous, List<T> current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        ArrayList<T> merged = new ArrayList<T>(previous);
        merged.addAll(current);
        return merged;
    }
}

