/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.metadata;

import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.util.Assert;

public class OpenAiUsage
implements Usage {
    private final OpenAiApi.Usage usage;

    protected OpenAiUsage(OpenAiApi.Usage usage) {
        Assert.notNull((Object)usage, (String)"OpenAI Usage must not be null");
        this.usage = usage;
    }

    public static OpenAiUsage from(OpenAiApi.Usage usage) {
        return new OpenAiUsage(usage);
    }

    protected OpenAiApi.Usage getUsage() {
        return this.usage;
    }

    public Long getPromptTokens() {
        Integer promptTokens = this.getUsage().promptTokens();
        return promptTokens != null ? promptTokens.longValue() : 0L;
    }

    public Long getGenerationTokens() {
        Integer generationTokens = this.getUsage().completionTokens();
        return generationTokens != null ? generationTokens.longValue() : 0L;
    }

    public Long getTotalTokens() {
        Integer totalTokens = this.getUsage().totalTokens();
        if (totalTokens != null) {
            return totalTokens.longValue();
        }
        return this.getPromptTokens() + this.getGenerationTokens();
    }

    @Deprecated
    public Long getPromptTokensDetailsCachedTokens() {
        OpenAiApi.Usage.PromptTokensDetails promptTokenDetails = this.getUsage().promptTokensDetails();
        Integer cachedTokens = promptTokenDetails != null ? promptTokenDetails.cachedTokens() : null;
        return cachedTokens != null ? cachedTokens.longValue() : 0L;
    }

    public PromptTokensDetails getPromptTokensDetails() {
        OpenAiApi.Usage.PromptTokensDetails details = this.getUsage().promptTokensDetails();
        if (details == null) {
            return new PromptTokensDetails(0, 0);
        }
        return new PromptTokensDetails(this.valueOrZero(details.audioTokens()), this.valueOrZero(details.cachedTokens()));
    }

    @Deprecated
    public Long getReasoningTokens() {
        OpenAiApi.Usage.CompletionTokenDetails completionTokenDetails = this.getUsage().completionTokenDetails();
        Integer reasoningTokens = completionTokenDetails != null ? completionTokenDetails.reasoningTokens() : null;
        return reasoningTokens != null ? reasoningTokens.longValue() : 0L;
    }

    @Deprecated
    public Long getAcceptedPredictionTokens() {
        OpenAiApi.Usage.CompletionTokenDetails completionTokenDetails = this.getUsage().completionTokenDetails();
        Integer acceptedPredictionTokens = completionTokenDetails != null ? completionTokenDetails.acceptedPredictionTokens() : null;
        return acceptedPredictionTokens != null ? acceptedPredictionTokens.longValue() : 0L;
    }

    @Deprecated
    public Long getAudioTokens() {
        OpenAiApi.Usage.CompletionTokenDetails completionTokenDetails = this.getUsage().completionTokenDetails();
        Integer audioTokens = completionTokenDetails != null ? completionTokenDetails.audioTokens() : null;
        return audioTokens != null ? audioTokens.longValue() : 0L;
    }

    @Deprecated
    public Long getRejectedPredictionTokens() {
        OpenAiApi.Usage.CompletionTokenDetails completionTokenDetails = this.getUsage().completionTokenDetails();
        Integer rejectedPredictionTokens = completionTokenDetails != null ? completionTokenDetails.rejectedPredictionTokens() : null;
        return rejectedPredictionTokens != null ? rejectedPredictionTokens.longValue() : 0L;
    }

    public CompletionTokenDetails getCompletionTokenDetails() {
        OpenAiApi.Usage.CompletionTokenDetails details = this.getUsage().completionTokenDetails();
        if (details == null) {
            return new CompletionTokenDetails(0, 0, 0, 0);
        }
        return new CompletionTokenDetails(this.valueOrZero(details.reasoningTokens()), this.valueOrZero(details.acceptedPredictionTokens()), this.valueOrZero(details.audioTokens()), this.valueOrZero(details.rejectedPredictionTokens()));
    }

    public String toString() {
        return this.getUsage().toString();
    }

    private int valueOrZero(Integer value) {
        return value != null ? value : 0;
    }

    public record PromptTokensDetails(Integer audioTokens, Integer cachedTokens) {
    }

    public record CompletionTokenDetails(Integer reasoningTokens, Integer acceptedPredictionTokens, Integer audioTokens, Integer rejectedPredictionTokens) {
    }
}

