/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.mariadb;

import org.springframework.ai.autoconfigure.vectorstore.CommonVectorStoreProperties;
import org.springframework.ai.vectorstore.mariadb.MariaDBVectorStore;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.ai.vectorstore.mariadb")
public class MariaDbStoreProperties
extends CommonVectorStoreProperties {
    public static final String CONFIG_PREFIX = "spring.ai.vectorstore.mariadb";
    private int dimensions = -1;
    private MariaDBVectorStore.MariaDBDistanceType distanceType = MariaDBVectorStore.MariaDBDistanceType.COSINE;
    private boolean removeExistingVectorStoreTable = false;
    private String tableName = "vector_store";
    private String schemaName = null;
    private String embeddingFieldName = "embedding";
    private String idFieldName = "id";
    private String metadataFieldName = "metadata";
    private String contentFieldName = "content";
    private boolean schemaValidation = false;
    private int maxDocumentBatchSize = 10000;

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
    }

    public MariaDBVectorStore.MariaDBDistanceType getDistanceType() {
        return this.distanceType;
    }

    public void setDistanceType(MariaDBVectorStore.MariaDBDistanceType distanceType) {
        this.distanceType = distanceType;
    }

    public boolean isRemoveExistingVectorStoreTable() {
        return this.removeExistingVectorStoreTable;
    }

    public void setRemoveExistingVectorStoreTable(boolean removeExistingVectorStoreTable) {
        this.removeExistingVectorStoreTable = removeExistingVectorStoreTable;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String vectorTableName) {
        this.tableName = vectorTableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean isSchemaValidation() {
        return this.schemaValidation;
    }

    public void setSchemaValidation(boolean schemaValidation) {
        this.schemaValidation = schemaValidation;
    }

    public int getMaxDocumentBatchSize() {
        return this.maxDocumentBatchSize;
    }

    public void setMaxDocumentBatchSize(int maxDocumentBatchSize) {
        this.maxDocumentBatchSize = maxDocumentBatchSize;
    }

    public String getEmbeddingFieldName() {
        return this.embeddingFieldName;
    }

    public void setEmbeddingFieldName(String embeddingFieldName) {
        this.embeddingFieldName = embeddingFieldName;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public void setIdFieldName(String idFieldName) {
        this.idFieldName = idFieldName;
    }

    public String getMetadataFieldName() {
        return this.metadataFieldName;
    }

    public void setMetadataFieldName(String metadataFieldName) {
        this.metadataFieldName = metadataFieldName;
    }

    public String getContentFieldName() {
        return this.contentFieldName;
    }

    public void setContentFieldName(String contentFieldName) {
        this.contentFieldName = contentFieldName;
    }
}

