/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.docker.compose.service.connection.chroma;

import org.springframework.ai.autoconfigure.vectorstore.chroma.ChromaConnectionDetails;
import org.springframework.ai.docker.compose.service.connection.chroma.ChromaEnvironment;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class ChromaDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<ChromaConnectionDetails> {
    private static final String[] CHROMA_IMAGE_NAMES = new String[]{"chromadb/chroma", "ghcr.io/chroma-core/chroma"};
    private static final int CHROMA_PORT = 8000;

    protected ChromaDockerComposeConnectionDetailsFactory() {
        super(CHROMA_IMAGE_NAMES, new String[0]);
    }

    protected ChromaConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new ChromaDockerComposeConnectionDetails(source.getRunningService());
    }

    static class ChromaDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements ChromaConnectionDetails {
        private final ChromaEnvironment environment;
        private final String host;
        private final int port;

        ChromaDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new ChromaEnvironment(service.env());
            this.host = service.host();
            this.port = service.ports().get(8000);
        }

        public String getHost() {
            return "http://%s".formatted(this.host);
        }

        public int getPort() {
            return this.port;
        }

        public String getKeyToken() {
            return this.environment.getKeyToken();
        }
    }
}

