/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.docker.compose.service.connection.qdrant;

import org.springframework.ai.autoconfigure.vectorstore.qdrant.QdrantConnectionDetails;
import org.springframework.ai.docker.compose.service.connection.qdrant.QdrantEnvironment;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class QdrantDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<QdrantConnectionDetails> {
    private static final int QDRANT_GRPC_PORT = 6334;

    protected QdrantDockerComposeConnectionDetailsFactory() {
        super("qdrant/qdrant", new String[0]);
    }

    protected QdrantConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new QdrantDockerComposeConnectionDetails(source.getRunningService());
    }

    static class QdrantDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements QdrantConnectionDetails {
        private final QdrantEnvironment environment;
        private final String host;
        private final int port;

        QdrantDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new QdrantEnvironment(service.env());
            this.host = service.host();
            this.port = service.ports().get(6334);
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getApiKey() {
            return this.environment.getApiKey();
        }
    }
}

