/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.template.st;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.template.TemplateRenderer;
import org.springframework.ai.template.ValidationMode;
import org.springframework.util.Assert;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.compiler.Compiler;

public class StTemplateRenderer
implements TemplateRenderer {
    private static final Logger logger = LoggerFactory.getLogger(StTemplateRenderer.class);
    private static final String VALIDATION_MESSAGE = "Not all variables were replaced in the template. Missing variable names are: %s.";
    private static final char DEFAULT_START_DELIMITER_TOKEN = '{';
    private static final char DEFAULT_END_DELIMITER_TOKEN = '}';
    private static final ValidationMode DEFAULT_VALIDATION_MODE = ValidationMode.THROW;
    private static final boolean DEFAULT_SUPPORT_ST_FUNCTIONS = false;
    private final char startDelimiterToken;
    private final char endDelimiterToken;
    private final ValidationMode validationMode;
    private final boolean supportStFunctions;

    StTemplateRenderer(char startDelimiterToken, char endDelimiterToken, ValidationMode validationMode, boolean supportStFunctions) {
        Assert.notNull((Object)validationMode, (String)"validationMode cannot be null");
        this.startDelimiterToken = startDelimiterToken;
        this.endDelimiterToken = endDelimiterToken;
        this.validationMode = validationMode;
        this.supportStFunctions = supportStFunctions;
    }

    public String apply(String template, Map<String, Object> variables) {
        Assert.hasText((String)template, (String)"template cannot be null or empty");
        Assert.notNull(variables, (String)"variables cannot be null");
        Assert.noNullElements(variables.keySet(), (String)"variables keys cannot be null");
        ST st = this.createST(template);
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            st.add(entry.getKey(), entry.getValue());
        }
        if (this.validationMode != ValidationMode.NONE) {
            this.validate(st, variables);
        }
        return st.render();
    }

    private ST createST(String template) {
        try {
            return new ST(template, this.startDelimiterToken, this.endDelimiterToken);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The template string is not valid.", ex);
        }
    }

    private void validate(ST st, Map<String, Object> templateVariables) {
        HashSet modelKeys;
        Set<String> templateTokens = this.getInputVariables(st);
        HashSet hashSet = modelKeys = templateVariables != null ? templateVariables.keySet() : new HashSet();
        if (!modelKeys.containsAll(templateTokens)) {
            templateTokens.removeAll(modelKeys);
            if (this.validationMode == ValidationMode.WARN) {
                logger.warn(VALIDATION_MESSAGE.formatted(templateTokens));
            } else if (this.validationMode == ValidationMode.THROW) {
                throw new IllegalStateException(VALIDATION_MESSAGE.formatted(templateTokens));
            }
        }
    }

    private Set<String> getInputVariables(ST st) {
        TokenStream tokens = st.impl.tokens;
        HashSet<String> inputVariables = new HashSet<String>();
        boolean isInsideList = false;
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (token.getType() == 23 && i + 1 < tokens.size() && tokens.get(i + 1).getType() == 25) {
                String text;
                if (i + 2 >= tokens.size() || tokens.get(i + 2).getType() != 13 || Compiler.funcs.containsKey(text = tokens.get(i + 1).getText()) && this.supportStFunctions) continue;
                inputVariables.add(text);
                isInsideList = true;
                continue;
            }
            if (token.getType() == 24) {
                isInsideList = false;
                continue;
            }
            if (isInsideList || token.getType() != 25 || Compiler.funcs.containsKey(token.getText()) && this.supportStFunctions) continue;
            inputVariables.add(token.getText());
        }
        return inputVariables;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private char startDelimiterToken = (char)123;
        private char endDelimiterToken = (char)125;
        private ValidationMode validationMode = DEFAULT_VALIDATION_MODE;
        private boolean supportStFunctions = false;

        private Builder() {
        }

        public Builder startDelimiterToken(char startDelimiterToken) {
            this.startDelimiterToken = startDelimiterToken;
            return this;
        }

        public Builder endDelimiterToken(char endDelimiterToken) {
            this.endDelimiterToken = endDelimiterToken;
            return this;
        }

        public Builder validationMode(ValidationMode validationMode) {
            this.validationMode = validationMode;
            return this;
        }

        public Builder supportStFunctions() {
            this.supportStFunctions = true;
            return this;
        }

        public StTemplateRenderer build() {
            return new StTemplateRenderer(this.startDelimiterToken, this.endDelimiterToken, this.validationMode, this.supportStFunctions);
        }
    }
}

