/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.embedding;

import com.google.cloud.aiplatform.v1.EndpointName;
import com.google.cloud.aiplatform.v1.PredictionServiceSettings;
import java.io.IOException;
import org.springframework.util.StringUtils;

public class VertexAiEmbeddingConnectionDetails {
    public static final String DEFAULT_ENDPOINT = "us-central1-aiplatform.googleapis.com:443";
    public static final String DEFAULT_ENDPOINT_SUFFIX = "-aiplatform.googleapis.com:443";
    public static final String DEFAULT_PUBLISHER = "google";
    private static final String DEFAULT_LOCATION = "us-central1";
    private final String projectId;
    private final String location;
    private final String publisher;
    private final PredictionServiceSettings predictionServiceSettings;

    public VertexAiEmbeddingConnectionDetails(String projectId, String location, String publisher, PredictionServiceSettings predictionServiceSettings) {
        this.projectId = projectId;
        this.location = location;
        this.publisher = publisher;
        this.predictionServiceSettings = predictionServiceSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public EndpointName getEndpointName(String modelName) {
        return EndpointName.ofProjectLocationPublisherModelName((String)this.projectId, (String)this.location, (String)this.publisher, (String)modelName);
    }

    public PredictionServiceSettings getPredictionServiceSettings() {
        return this.predictionServiceSettings;
    }

    public static class Builder {
        private String endpoint;
        private String projectId;
        private String location;
        private String publisher;
        private PredictionServiceSettings predictionServiceSettings;

        public Builder apiEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder predictionServiceSettings(PredictionServiceSettings predictionServiceSettings) {
            this.predictionServiceSettings = predictionServiceSettings;
            return this;
        }

        public VertexAiEmbeddingConnectionDetails build() {
            if (!StringUtils.hasText((String)this.endpoint)) {
                if (!StringUtils.hasText((String)this.location)) {
                    this.endpoint = VertexAiEmbeddingConnectionDetails.DEFAULT_ENDPOINT;
                    this.location = VertexAiEmbeddingConnectionDetails.DEFAULT_LOCATION;
                } else {
                    this.endpoint = this.location + VertexAiEmbeddingConnectionDetails.DEFAULT_ENDPOINT_SUFFIX;
                }
            }
            if (!StringUtils.hasText((String)this.publisher)) {
                this.publisher = VertexAiEmbeddingConnectionDetails.DEFAULT_PUBLISHER;
            }
            if (this.predictionServiceSettings == null) {
                try {
                    this.predictionServiceSettings = ((PredictionServiceSettings.Builder)PredictionServiceSettings.newBuilder().setEndpoint(this.endpoint)).build();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new VertexAiEmbeddingConnectionDetails(this.projectId, this.location, this.publisher, this.predictionServiceSettings);
        }
    }
}

