/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.gemini;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.cloud.vertexai.VertexAI;
import com.google.cloud.vertexai.api.Candidate;
import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.FunctionCall;
import com.google.cloud.vertexai.api.FunctionDeclaration;
import com.google.cloud.vertexai.api.FunctionResponse;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.GoogleSearchRetrieval;
import com.google.cloud.vertexai.api.Part;
import com.google.cloud.vertexai.api.SafetySetting;
import com.google.cloud.vertexai.api.Schema;
import com.google.cloud.vertexai.api.Tool;
import com.google.cloud.vertexai.generativeai.GenerativeModel;
import com.google.cloud.vertexai.generativeai.PartMaker;
import com.google.cloud.vertexai.generativeai.ResponseStream;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.AbstractToolCallSupport;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.ai.model.Media;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.vertexai.gemini.VertexAiGeminiChatOptions;
import org.springframework.ai.vertexai.gemini.common.VertexAiGeminiConstants;
import org.springframework.ai.vertexai.gemini.common.VertexAiGeminiSafetySetting;
import org.springframework.ai.vertexai.gemini.metadata.VertexAiUsage;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.NonNull;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class VertexAiGeminiChatModel
extends AbstractToolCallSupport
implements org.springframework.ai.chat.model.ChatModel,
DisposableBean {
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private final VertexAI vertexAI;
    private final VertexAiGeminiChatOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final GenerationConfig generationConfig;
    private final ObservationRegistry observationRegistry;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public VertexAiGeminiChatModel(VertexAI vertexAI) {
        this(vertexAI, VertexAiGeminiChatOptions.builder().model(ChatModel.GEMINI_1_5_PRO).temperature(0.8).build());
    }

    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions options) {
        this(vertexAI, options, null);
    }

    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions options, FunctionCallbackResolver functionCallbackResolver) {
        this(vertexAI, options, functionCallbackResolver, List.of());
    }

    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions options, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks) {
        this(vertexAI, options, functionCallbackResolver, toolFunctionCallbacks, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions options, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks, RetryTemplate retryTemplate) {
        this(vertexAI, options, functionCallbackResolver, toolFunctionCallbacks, retryTemplate, ObservationRegistry.NOOP);
    }

    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions options, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        super(functionCallbackResolver, (FunctionCallingOptions)options, toolFunctionCallbacks);
        Assert.notNull((Object)vertexAI, (String)"VertexAI must not be null");
        Assert.notNull((Object)options, (String)"VertexAiGeminiChatOptions must not be null");
        Assert.notNull((Object)options.getModel(), (String)"VertexAiGeminiChatOptions.modelName must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        this.vertexAI = vertexAI;
        this.defaultOptions = options;
        this.generationConfig = this.toGenerationConfig(options);
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    private static GeminiMessageType toGeminiMessageType(@NonNull MessageType type) {
        Assert.notNull((Object)type, (String)"Message type must not be null");
        switch (type) {
            case SYSTEM: 
            case USER: 
            case TOOL: {
                return GeminiMessageType.USER;
            }
            case ASSISTANT: {
                return GeminiMessageType.MODEL;
            }
        }
        throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(type));
    }

    static List<Part> messageToGeminiParts(Message message) {
        if (message instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (systemMessage.getText() != null) {
                parts.add(Part.newBuilder().setText(systemMessage.getText()).build());
            }
            return parts;
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (userMessage.getText() != null) {
                parts.add(Part.newBuilder().setText(userMessage.getText()).build());
            }
            parts.addAll(VertexAiGeminiChatModel.mediaToParts(userMessage.getMedia()));
            return parts;
        }
        if (message instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (StringUtils.hasText((String)assistantMessage.getText())) {
                parts.add(Part.newBuilder().setText(assistantMessage.getText()).build());
            }
            if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                parts.addAll(assistantMessage.getToolCalls().stream().map(toolCall -> Part.newBuilder().setFunctionCall(FunctionCall.newBuilder().setName(toolCall.name()).setArgs(VertexAiGeminiChatModel.jsonToStruct(toolCall.arguments())).build()).build()).toList());
            }
            return parts;
        }
        if (message instanceof ToolResponseMessage) {
            ToolResponseMessage toolResponseMessage = (ToolResponseMessage)message;
            return toolResponseMessage.getResponses().stream().map(response -> Part.newBuilder().setFunctionResponse(FunctionResponse.newBuilder().setName(response.name()).setResponse(VertexAiGeminiChatModel.jsonToStruct(response.responseData())).build()).build()).toList();
        }
        throw new IllegalArgumentException("Gemini doesn't support message type: " + String.valueOf(message.getClass()));
    }

    private static List<Part> mediaToParts(Collection<Media> media) {
        ArrayList<Part> parts = new ArrayList<Part>();
        List<Part> mediaParts = media.stream().map(mediaData -> PartMaker.fromMimeTypeAndData((String)mediaData.getMimeType().toString(), (Object)mediaData.getData())).toList();
        if (!CollectionUtils.isEmpty(mediaParts)) {
            parts.addAll(mediaParts);
        }
        return parts;
    }

    private static String structToJson(Struct struct) {
        try {
            return JsonFormat.printer().print((MessageOrBuilder)struct);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Struct jsonToStruct(String json) {
        try {
            Struct.Builder structBuilder = Struct.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(json, (Message.Builder)structBuilder);
            return structBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Schema jsonToSchema(String json) {
        try {
            Schema.Builder schemaBuilder = Schema.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(json, (Message.Builder)schemaBuilder);
            return schemaBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ChatResponse call(Prompt prompt) {
        VertexAiGeminiChatOptions vertexAiGeminiChatOptions = this.vertexAiGeminiChatOptions(prompt);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(VertexAiGeminiConstants.PROVIDER_NAME).requestOptions((ChatOptions)vertexAiGeminiChatOptions).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> (ChatResponse)this.retryTemplate.execute(context -> {
            GeminiRequest geminiRequest = this.createGeminiRequest(prompt, vertexAiGeminiChatOptions);
            GenerateContentResponse generateContentResponse = this.getContentResponse(geminiRequest);
            List generations = generateContentResponse.getCandidatesList().stream().map(this::responseCandidateToGeneration).flatMap(Collection::stream).toList();
            ChatResponse chatResponse = new ChatResponse(generations, this.toChatResponseMetadata(generateContentResponse));
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        }));
        if (!this.isProxyToolCalls(prompt, this.defaultOptions) && this.isToolCall(response, Set.of(Candidate.FinishReason.STOP.name()))) {
            List toolCallConversation = this.handleToolCalls(prompt, response);
            return this.call(new Prompt(toolCallConversation, prompt.getOptions()));
        }
        return response;
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        return Flux.deferContextual(contextView -> {
            VertexAiGeminiChatOptions vertexAiGeminiChatOptions = this.vertexAiGeminiChatOptions(prompt);
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(VertexAiGeminiConstants.PROVIDER_NAME).requestOptions((ChatOptions)vertexAiGeminiChatOptions).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            GeminiRequest request = this.createGeminiRequest(prompt, vertexAiGeminiChatOptions);
            try {
                ResponseStream responseStream = request.model.generateContentStream(request.contents);
                return Flux.fromStream((Stream)responseStream.stream()).switchMap(response -> {
                    List generations = response.getCandidatesList().stream().map(this::responseCandidateToGeneration).flatMap(Collection::stream).toList();
                    ChatResponse chatResponse = new ChatResponse(generations, this.toChatResponseMetadata((GenerateContentResponse)response));
                    if (!this.isProxyToolCalls(prompt, this.defaultOptions) && this.isToolCall(chatResponse, Set.of(Candidate.FinishReason.STOP.name(), Candidate.FinishReason.FINISH_REASON_UNSPECIFIED.name()))) {
                        List toolCallConversation = this.handleToolCalls(prompt, chatResponse);
                        return this.stream(new Prompt(toolCallConversation, prompt.getOptions()));
                    }
                    Flux chatResponseFlux = Flux.just((Object)chatResponse).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
                    return new MessageAggregator().aggregate(chatResponseFlux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
                });
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate content", e);
            }
        });
    }

    protected List<Generation> responseCandidateToGeneration(Candidate candidate) {
        int candidateIndex = candidate.getIndex();
        Candidate.FinishReason candidateFinishReason = candidate.getFinishReason();
        Map<String, Candidate.FinishReason> messageMetadata = Map.of("candidateIndex", candidateIndex, "finishReason", candidateFinishReason);
        ChatGenerationMetadata chatGenerationMetadata = ChatGenerationMetadata.builder().finishReason(candidateFinishReason.name()).build();
        boolean isFunctionCall = candidate.getContent().getPartsList().stream().allMatch(Part::hasFunctionCall);
        if (isFunctionCall) {
            List<AssistantMessage.ToolCall> assistantToolCalls = candidate.getContent().getPartsList().stream().filter(part -> part.hasFunctionCall()).map(part -> {
                FunctionCall functionCall = part.getFunctionCall();
                String functionName = functionCall.getName();
                String functionArguments = VertexAiGeminiChatModel.structToJson(functionCall.getArgs());
                return new AssistantMessage.ToolCall("", "function", functionName, functionArguments);
            }).toList();
            AssistantMessage assistantMessage2 = new AssistantMessage("", messageMetadata, assistantToolCalls);
            return List.of(new Generation(assistantMessage2, chatGenerationMetadata));
        }
        List<Generation> generations = candidate.getContent().getPartsList().stream().map(part -> new AssistantMessage(part.getText(), messageMetadata)).map(assistantMessage -> new Generation(assistantMessage, chatGenerationMetadata)).toList();
        return generations;
    }

    private ChatResponseMetadata toChatResponseMetadata(GenerateContentResponse response) {
        return ChatResponseMetadata.builder().usage((Usage)new VertexAiUsage(response.getUsageMetadata())).build();
    }

    private VertexAiGeminiChatOptions vertexAiGeminiChatOptions(Prompt prompt) {
        VertexAiGeminiChatOptions updatedRuntimeOptions = VertexAiGeminiChatOptions.builder().build();
        if (prompt.getOptions() != null) {
            updatedRuntimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, VertexAiGeminiChatOptions.class);
        }
        updatedRuntimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)this.defaultOptions, VertexAiGeminiChatOptions.class);
        return updatedRuntimeOptions;
    }

    GeminiRequest createGeminiRequest(Prompt prompt, VertexAiGeminiChatOptions updatedRuntimeOptions) {
        ChatOptions googleSearchRetrieval;
        VertexAiGeminiChatOptions options;
        ChatOptions chatOptions;
        HashSet<String> functionsForThisRequest = new HashSet<String>();
        GenerationConfig generationConfig = this.generationConfig;
        GenerativeModel.Builder generativeModelBuilder = new GenerativeModel.Builder().setModelName(this.defaultOptions.getModel()).setVertexAi(this.vertexAI).setSafetySettings(this.toGeminiSafetySettings(this.defaultOptions.getSafetySettings()));
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions2 = prompt.getOptions();
            if (chatOptions2 instanceof FunctionCallingOptions) {
                FunctionCallingOptions functionCallingOptions = (FunctionCallingOptions)chatOptions2;
                updatedRuntimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.copyToTarget((Object)functionCallingOptions, FunctionCallingOptions.class, VertexAiGeminiChatOptions.class);
            } else {
                updatedRuntimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, VertexAiGeminiChatOptions.class);
            }
            functionsForThisRequest.addAll(this.runtimeFunctionCallbackConfigurations(updatedRuntimeOptions));
        }
        if (!CollectionUtils.isEmpty(this.defaultOptions.getFunctions())) {
            functionsForThisRequest.addAll(this.defaultOptions.getFunctions());
        }
        if (updatedRuntimeOptions != null) {
            if (StringUtils.hasText((String)updatedRuntimeOptions.getModel()) && !updatedRuntimeOptions.getModel().equals(this.defaultOptions.getModel())) {
                generativeModelBuilder.setModelName(updatedRuntimeOptions.getModel());
            }
            generationConfig = this.toGenerationConfig(updatedRuntimeOptions);
        }
        ArrayList<Tool> tools = new ArrayList<Tool>();
        if (!CollectionUtils.isEmpty(functionsForThisRequest)) {
            tools.addAll(this.getFunctionTools(functionsForThisRequest));
        }
        if ((chatOptions = prompt.getOptions()) instanceof VertexAiGeminiChatOptions && (options = (VertexAiGeminiChatOptions)chatOptions).getGoogleSearchRetrieval()) {
            googleSearchRetrieval = GoogleSearchRetrieval.newBuilder().getDefaultInstanceForType();
            Tool googleSearchRetrievalTool = Tool.newBuilder().setGoogleSearchRetrieval((GoogleSearchRetrieval)googleSearchRetrieval).build();
            tools.add(googleSearchRetrievalTool);
        }
        if (!CollectionUtils.isEmpty(tools)) {
            generativeModelBuilder.setTools(tools);
        }
        if ((googleSearchRetrieval = prompt.getOptions()) instanceof VertexAiGeminiChatOptions && !CollectionUtils.isEmpty((options = (VertexAiGeminiChatOptions)googleSearchRetrieval).getSafetySettings())) {
            generativeModelBuilder.setSafetySettings(this.toGeminiSafetySettings(options.getSafetySettings()));
        }
        generativeModelBuilder.setGenerationConfig(generationConfig);
        GenerativeModel generativeModel = generativeModelBuilder.build();
        List<Content> contents = this.toGeminiContent(prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.SYSTEM).toList());
        if (!CollectionUtils.isEmpty(contents)) {
            Assert.isTrue((contents.size() <= 1 ? 1 : 0) != 0, (String)"Only one system message is allowed in the prompt");
            generativeModel = generativeModel.withSystemInstruction(contents.get(0));
        }
        return new GeminiRequest(this.toGeminiContent(prompt.getInstructions().stream().filter(m -> m.getMessageType() != MessageType.SYSTEM).toList()), generativeModel);
    }

    private GenerationConfig toGenerationConfig(VertexAiGeminiChatOptions options) {
        GenerationConfig.Builder generationConfigBuilder = GenerationConfig.newBuilder();
        if (options.getTemperature() != null) {
            generationConfigBuilder.setTemperature(options.getTemperature().floatValue());
        }
        if (options.getMaxOutputTokens() != null) {
            generationConfigBuilder.setMaxOutputTokens(options.getMaxOutputTokens().intValue());
        }
        if (options.getTopK() != null) {
            generationConfigBuilder.setTopK((float)options.getTopK().intValue());
        }
        if (options.getTopP() != null) {
            generationConfigBuilder.setTopP(options.getTopP().floatValue());
        }
        if (options.getCandidateCount() != null) {
            generationConfigBuilder.setCandidateCount(options.getCandidateCount().intValue());
        }
        if (options.getStopSequences() != null) {
            generationConfigBuilder.addAllStopSequences(options.getStopSequences());
        }
        if (options.getResponseMimeType() != null) {
            generationConfigBuilder.setResponseMimeType(options.getResponseMimeType());
        }
        return generationConfigBuilder.build();
    }

    private List<Content> toGeminiContent(List<Message> instrucitons) {
        List<Content> contents = instrucitons.stream().map(message -> Content.newBuilder().setRole(VertexAiGeminiChatModel.toGeminiMessageType(message.getMessageType()).getValue()).addAllParts(VertexAiGeminiChatModel.messageToGeminiParts(message)).build()).toList();
        return contents;
    }

    private List<SafetySetting> toGeminiSafetySettings(List<VertexAiGeminiSafetySetting> safetySettings) {
        return safetySettings.stream().map(safetySetting -> SafetySetting.newBuilder().setCategoryValue(safetySetting.getCategory().getValue()).setThresholdValue(safetySetting.getThreshold().getValue()).setMethodValue(safetySetting.getMethod().getValue()).build()).toList();
    }

    private List<Tool> getFunctionTools(Set<String> functionNames) {
        Tool.Builder tool = Tool.newBuilder();
        List<FunctionDeclaration> functionDeclarations = this.resolveFunctionCallbacks(functionNames).stream().map(functionCallback -> FunctionDeclaration.newBuilder().setName(functionCallback.getName()).setDescription(functionCallback.getDescription()).setParameters(VertexAiGeminiChatModel.jsonToSchema(functionCallback.getInputTypeSchema())).build()).toList();
        tool.addAllFunctionDeclarations(functionDeclarations);
        return List.of(tool.build());
    }

    GenerateContentResponse getContentResponse(GeminiRequest request) {
        try {
            return request.model.generateContent(request.contents);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate content", e);
        }
    }

    public ChatOptions getDefaultOptions() {
        return VertexAiGeminiChatOptions.fromOptions(this.defaultOptions);
    }

    public void destroy() throws Exception {
        if (this.vertexAI != null) {
            this.vertexAI.close();
        }
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public static enum ChatModel implements ChatModelDescription
    {
        GEMINI_PRO_VISION("gemini-pro-vision"),
        GEMINI_PRO("gemini-pro"),
        GEMINI_1_5_PRO("gemini-1.5-pro-001"),
        GEMINI_1_5_FLASH("gemini-1.5-flash-001");

        public final String value;

        private ChatModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.value;
        }
    }

    public static enum GeminiMessageType {
        USER("user"),
        MODEL("model");

        public final String value;

        private GeminiMessageType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record GeminiRequest(List<Content> contents, GenerativeModel model) {
    }
}

