/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.gemini;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.vertexai.gemini.VertexAiGeminiChatModel;
import org.springframework.ai.vertexai.gemini.common.VertexAiGeminiSafetySetting;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VertexAiGeminiChatOptions
implements FunctionCallingOptions {
    @JsonProperty(value="stopSequences")
    private List<String> stopSequences;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="topP")
    private Double topP;
    @JsonProperty(value="topK")
    private Integer topK;
    @JsonProperty(value="candidateCount")
    private Integer candidateCount;
    @JsonProperty(value="maxOutputTokens")
    private Integer maxOutputTokens;
    @JsonProperty(value="modelName")
    private String model;
    @JsonProperty(value="responseMimeType")
    private String responseMimeType;
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();
    @JsonIgnore
    private boolean googleSearchRetrieval = false;
    @JsonIgnore
    private List<VertexAiGeminiSafetySetting> safetySettings = new ArrayList<VertexAiGeminiSafetySetting>();
    @JsonIgnore
    private Boolean proxyToolCalls;
    @JsonIgnore
    private Map<String, Object> toolContext;

    public static Builder builder() {
        return new Builder();
    }

    public static VertexAiGeminiChatOptions fromOptions(VertexAiGeminiChatOptions fromOptions) {
        VertexAiGeminiChatOptions options = new VertexAiGeminiChatOptions();
        options.setStopSequences(fromOptions.getStopSequences());
        options.setTemperature(fromOptions.getTemperature());
        options.setTopP(fromOptions.getTopP());
        options.setTopK(fromOptions.getTopK());
        options.setCandidateCount(fromOptions.getCandidateCount());
        options.setMaxOutputTokens(fromOptions.getMaxOutputTokens());
        options.setModel(fromOptions.getModel());
        options.setFunctionCallbacks(fromOptions.getFunctionCallbacks());
        options.setResponseMimeType(fromOptions.getResponseMimeType());
        options.setFunctions(fromOptions.getFunctions());
        options.setResponseMimeType(fromOptions.getResponseMimeType());
        options.setGoogleSearchRetrieval(fromOptions.getGoogleSearchRetrieval());
        options.setSafetySettings(fromOptions.getSafetySettings());
        options.setProxyToolCalls(fromOptions.getProxyToolCalls());
        options.setToolContext(fromOptions.getToolContext());
        return options;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public Integer getCandidateCount() {
        return this.candidateCount;
    }

    public void setCandidateCount(Integer candidateCount) {
        this.candidateCount = candidateCount;
    }

    @JsonIgnore
    public Integer getMaxTokens() {
        return this.getMaxOutputTokens();
    }

    @JsonIgnore
    public void setMaxTokens(Integer maxTokens) {
        this.setMaxOutputTokens(maxTokens);
    }

    public Integer getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    public void setMaxOutputTokens(Integer maxOutputTokens) {
        this.maxOutputTokens = maxOutputTokens;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String modelName) {
        this.model = modelName;
    }

    public String getResponseMimeType() {
        return this.responseMimeType;
    }

    public void setResponseMimeType(String mimeType) {
        this.responseMimeType = mimeType;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functions) {
        this.functions = functions;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    public boolean getGoogleSearchRetrieval() {
        return this.googleSearchRetrieval;
    }

    public void setGoogleSearchRetrieval(boolean googleSearchRetrieval) {
        this.googleSearchRetrieval = googleSearchRetrieval;
    }

    public List<VertexAiGeminiSafetySetting> getSafetySettings() {
        return this.safetySettings;
    }

    public void setSafetySettings(List<VertexAiGeminiSafetySetting> safetySettings) {
        Assert.notNull(safetySettings, (String)"safetySettings must not be null");
        this.safetySettings = safetySettings;
    }

    public Boolean getProxyToolCalls() {
        return this.proxyToolCalls;
    }

    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VertexAiGeminiChatOptions)) {
            return false;
        }
        VertexAiGeminiChatOptions that = (VertexAiGeminiChatOptions)o;
        return this.googleSearchRetrieval == that.googleSearchRetrieval && Objects.equals(this.stopSequences, that.stopSequences) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topP, that.topP) && Objects.equals(this.topK, that.topK) && Objects.equals(this.candidateCount, that.candidateCount) && Objects.equals(this.maxOutputTokens, that.maxOutputTokens) && Objects.equals(this.model, that.model) && Objects.equals(this.responseMimeType, that.responseMimeType) && Objects.equals(this.functionCallbacks, that.functionCallbacks) && Objects.equals(this.functions, that.functions) && Objects.equals(this.safetySettings, that.safetySettings) && Objects.equals(this.proxyToolCalls, that.proxyToolCalls) && Objects.equals(this.toolContext, that.toolContext);
    }

    public int hashCode() {
        return Objects.hash(this.stopSequences, this.temperature, this.topP, this.topK, this.candidateCount, this.maxOutputTokens, this.model, this.responseMimeType, this.functionCallbacks, this.functions, this.googleSearchRetrieval, this.safetySettings, this.proxyToolCalls, this.toolContext);
    }

    public String toString() {
        return "VertexAiGeminiChatOptions{stopSequences=" + String.valueOf(this.stopSequences) + ", temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ", candidateCount=" + this.candidateCount + ", maxOutputTokens=" + this.maxOutputTokens + ", model='" + this.model + "', responseMimeType='" + this.responseMimeType + "', functionCallbacks=" + String.valueOf(this.functionCallbacks) + ", functions=" + String.valueOf(this.functions) + ", googleSearchRetrieval=" + this.googleSearchRetrieval + ", safetySettings=" + String.valueOf(this.safetySettings) + "}";
    }

    public VertexAiGeminiChatOptions copy() {
        return VertexAiGeminiChatOptions.fromOptions(this);
    }

    public FunctionCallingOptions merge(ChatOptions options) {
        Builder builder = VertexAiGeminiChatOptions.builder();
        builder.model(options.getModel() != null ? options.getModel() : this.getModel()).maxOutputTokens(options.getMaxTokens() != null ? options.getMaxTokens() : this.getMaxOutputTokens()).stopSequences(options.getStopSequences() != null ? options.getStopSequences() : this.getStopSequences()).temperature(options.getTemperature() != null ? options.getTemperature() : this.getTemperature()).topP(options.getTopP() != null ? options.getTopP() : this.getTopP()).topK(options.getTopK() != null ? options.getTopK() : this.getTopK());
        if (options instanceof FunctionCallingOptions) {
            FunctionCallingOptions functionOptions = (FunctionCallingOptions)options;
            builder.proxyToolCalls(functionOptions.getProxyToolCalls() != null ? functionOptions.getProxyToolCalls() : this.proxyToolCalls);
            HashSet<String> functions = new HashSet<String>();
            if (this.functions != null) {
                functions.addAll(this.functions);
            }
            if (functionOptions.getFunctions() != null) {
                functions.addAll(functionOptions.getFunctions());
            }
            builder.functions(functions);
            ArrayList<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
            if (this.functionCallbacks != null) {
                functionCallbacks.addAll(this.functionCallbacks);
            }
            if (functionOptions.getFunctionCallbacks() != null) {
                functionCallbacks.addAll(functionOptions.getFunctionCallbacks());
            }
            builder.functionCallbacks(functionCallbacks);
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (this.toolContext != null) {
                context.putAll(this.toolContext);
            }
            if (functionOptions.getToolContext() != null) {
                context.putAll(functionOptions.getToolContext());
            }
            builder.toolContext(context);
        } else {
            builder.proxyToolCalls(this.proxyToolCalls);
            builder.functions((Set<String>)(this.functions != null ? new HashSet<String>(this.functions) : null));
            builder.functionCallbacks((List<FunctionCallback>)(this.functionCallbacks != null ? new ArrayList<FunctionCallback>(this.functionCallbacks) : null));
            builder.toolContext((Map<String, Object>)(this.toolContext != null ? new HashMap<String, Object>(this.toolContext) : null));
        }
        builder.candidateCount(this.candidateCount).responseMimeType(this.responseMimeType).googleSearchRetrieval(this.googleSearchRetrieval).safetySettings((List<VertexAiGeminiSafetySetting>)(this.safetySettings != null ? new ArrayList<VertexAiGeminiSafetySetting>(this.safetySettings) : null));
        return builder.build();
    }

    public static class Builder {
        private VertexAiGeminiChatOptions options = new VertexAiGeminiChatOptions();

        public Builder stopSequences(List<String> stopSequences) {
            this.options.setStopSequences(stopSequences);
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder topP(Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder topK(Integer topK) {
            this.options.setTopK(topK);
            return this;
        }

        public Builder candidateCount(Integer candidateCount) {
            this.options.setCandidateCount(candidateCount);
            return this;
        }

        public Builder maxOutputTokens(Integer maxOutputTokens) {
            this.options.setMaxOutputTokens(maxOutputTokens);
            return this;
        }

        public Builder model(String modelName) {
            this.options.setModel(modelName);
            return this;
        }

        public Builder model(VertexAiGeminiChatModel.ChatModel model) {
            this.options.setModel(model.getValue());
            return this;
        }

        public Builder responseMimeType(String mimeType) {
            Assert.notNull((Object)mimeType, (String)"mimeType must not be null");
            this.options.setResponseMimeType(mimeType);
            return this;
        }

        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder functions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public Builder function(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public Builder googleSearchRetrieval(boolean googleSearch) {
            this.options.googleSearchRetrieval = googleSearch;
            return this;
        }

        public Builder safetySettings(List<VertexAiGeminiSafetySetting> safetySettings) {
            Assert.notNull(safetySettings, (String)"safetySettings must not be null");
            this.options.safetySettings = safetySettings;
            return this;
        }

        public Builder proxyToolCalls(boolean proxyToolCalls) {
            this.options.proxyToolCalls = proxyToolCalls;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withStopSequences(List<String> stopSequences) {
            this.options.setStopSequences(stopSequences);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTemperature(Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTopP(Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTopK(Integer topK) {
            this.options.setTopK(topK);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withCandidateCount(Integer candidateCount) {
            this.options.setCandidateCount(candidateCount);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMaxOutputTokens(Integer maxOutputTokens) {
            this.options.setMaxOutputTokens(maxOutputTokens);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(String modelName) {
            this.options.setModel(modelName);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(VertexAiGeminiChatModel.ChatModel model) {
            this.options.setModel(model.getValue());
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withResponseMimeType(String mimeType) {
            Assert.notNull((Object)mimeType, (String)"mimeType must not be null");
            this.options.setResponseMimeType(mimeType);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunctions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withFunction(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withGoogleSearchRetrieval(boolean googleSearch) {
            this.options.googleSearchRetrieval = googleSearch;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withSafetySettings(List<VertexAiGeminiSafetySetting> safetySettings) {
            Assert.notNull(safetySettings, (String)"safetySettings must not be null");
            this.options.safetySettings = safetySettings;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withProxyToolCalls(boolean proxyToolCalls) {
            this.options.proxyToolCalls = proxyToolCalls;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withToolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public VertexAiGeminiChatOptions build() {
            return this.options;
        }
    }

    public static enum TransportType {
        GRPC,
        REST;

    }
}

