/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.watsonx;

import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.watsonx.WatsonxAiChatOptions;
import org.springframework.ai.watsonx.api.WatsonxAiApi;
import org.springframework.ai.watsonx.api.WatsonxAiChatRequest;
import org.springframework.ai.watsonx.api.WatsonxAiChatResponse;
import org.springframework.ai.watsonx.utils.MessageToPromptConverter;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class WatsonxAiChatModel
implements ChatModel,
StreamingChatModel {
    private final WatsonxAiApi watsonxAiApi;
    private final WatsonxAiChatOptions defaultOptions;

    public WatsonxAiChatModel(WatsonxAiApi watsonxAiApi) {
        this(watsonxAiApi, WatsonxAiChatOptions.builder().temperature(0.7).topP(1.0).topK(50).decodingMethod("greedy").maxNewTokens(20).minNewTokens(0).repetitionPenalty(1.0).stopSequences(List.of()).build());
    }

    public WatsonxAiChatModel(WatsonxAiApi watsonxAiApi, WatsonxAiChatOptions defaultOptions) {
        Assert.notNull((Object)watsonxAiApi, (String)"watsonxAiApi cannot be null");
        Assert.notNull((Object)defaultOptions, (String)"defaultOptions cannot be null");
        this.watsonxAiApi = watsonxAiApi;
        this.defaultOptions = defaultOptions;
    }

    public ChatResponse call(Prompt prompt) {
        WatsonxAiChatRequest request = this.request(prompt);
        WatsonxAiChatResponse response = (WatsonxAiChatResponse)this.watsonxAiApi.generate(request).getBody();
        Generation generation = new Generation(new AssistantMessage(response.results().get(0).generatedText()), ChatGenerationMetadata.builder().finishReason(response.results().get(0).stopReason()).metadata("system", response.system()).build());
        return new ChatResponse(List.of(generation));
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        WatsonxAiChatRequest request = this.request(prompt);
        Flux<WatsonxAiChatResponse> response = this.watsonxAiApi.generateStreaming(request);
        return response.map(chunk -> {
            String generatedText = chunk.results().get(0).generatedText();
            AssistantMessage assistantMessage = new AssistantMessage(generatedText);
            ChatGenerationMetadata metadata = ChatGenerationMetadata.NULL;
            if (chunk.system() != null) {
                metadata = ChatGenerationMetadata.builder().finishReason(chunk.results().get(0).stopReason()).metadata("system", chunk.system()).build();
            }
            Generation generation = new Generation(assistantMessage, metadata);
            return new ChatResponse(List.of(generation));
        });
    }

    public WatsonxAiChatRequest request(Prompt prompt) {
        WatsonxAiChatOptions options = WatsonxAiChatOptions.builder().build();
        if (this.defaultOptions != null) {
            options = (WatsonxAiChatOptions)ModelOptionsUtils.merge((Object)options, (Object)this.defaultOptions, WatsonxAiChatOptions.class);
        }
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof WatsonxAiChatOptions) {
                WatsonxAiChatOptions runtimeOptions = (WatsonxAiChatOptions)chatOptions;
                options = (WatsonxAiChatOptions)ModelOptionsUtils.merge((Object)runtimeOptions, (Object)options, WatsonxAiChatOptions.class);
            } else {
                WatsonxAiChatOptions updatedRuntimeOptions = (WatsonxAiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, WatsonxAiChatOptions.class);
                options = (WatsonxAiChatOptions)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)options, WatsonxAiChatOptions.class);
            }
        }
        Map<String, Object> parameters = options.toMap();
        String convertedPrompt = MessageToPromptConverter.create().withAssistantPrompt("").withHumanPrompt("").toPrompt(prompt.getInstructions());
        return WatsonxAiChatRequest.builder(convertedPrompt).withParameters(parameters).build();
    }

    public ChatOptions getDefaultOptions() {
        return WatsonxAiChatOptions.fromOptions(this.defaultOptions);
    }
}

