/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.watsonx;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.ai.chat.prompt.ChatOptions;

public class WatsonxAiChatOptions
implements ChatOptions {
    @JsonIgnore
    private final ObjectMapper mapper = new ObjectMapper();
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="decoding_method")
    private String decodingMethod;
    @JsonProperty(value="max_new_tokens")
    private Integer maxNewTokens;
    @JsonProperty(value="min_new_tokens")
    private Integer minNewTokens;
    @JsonProperty(value="stop_sequences")
    private List<String> stopSequences;
    @JsonProperty(value="repetition_penalty")
    private Double repetitionPenalty;
    @JsonProperty(value="random_seed")
    private Integer randomSeed;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="additional")
    private Map<String, Object> additional = new HashMap<String, Object>();

    public static Builder builder() {
        return new Builder();
    }

    public static Map<String, Object> filterNonSupportedFields(Map<String, Object> options) {
        return options.entrySet().stream().filter(e -> !((String)e.getKey()).equals("model")).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static WatsonxAiChatOptions fromOptions(WatsonxAiChatOptions fromOptions) {
        return WatsonxAiChatOptions.builder().temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).topK(fromOptions.getTopK()).decodingMethod(fromOptions.getDecodingMethod()).maxNewTokens(fromOptions.getMaxNewTokens()).minNewTokens(fromOptions.getMinNewTokens()).stopSequences(fromOptions.getStopSequences()).repetitionPenalty(fromOptions.getRepetitionPenalty()).randomSeed(fromOptions.getRandomSeed()).model(fromOptions.getModel()).additionalProperties(fromOptions.getAdditionalProperties()).build();
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public String getDecodingMethod() {
        return this.decodingMethod;
    }

    public void setDecodingMethod(String decodingMethod) {
        this.decodingMethod = decodingMethod;
    }

    @JsonIgnore
    public Integer getMaxTokens() {
        return this.getMaxNewTokens();
    }

    @JsonIgnore
    public void setMaxTokens(Integer maxTokens) {
        this.setMaxNewTokens(maxTokens);
    }

    public Integer getMaxNewTokens() {
        return this.maxNewTokens;
    }

    public void setMaxNewTokens(Integer maxNewTokens) {
        this.maxNewTokens = maxNewTokens;
    }

    public Integer getMinNewTokens() {
        return this.minNewTokens;
    }

    public void setMinNewTokens(Integer minNewTokens) {
        this.minNewTokens = minNewTokens;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return this.getRepetitionPenalty();
    }

    @JsonIgnore
    public void setPresencePenalty(Double presencePenalty) {
        this.setRepetitionPenalty(presencePenalty);
    }

    public Double getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public void setRepetitionPenalty(Double repetitionPenalty) {
        this.repetitionPenalty = repetitionPenalty;
    }

    public Integer getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Integer randomSeed) {
        this.randomSeed = randomSeed;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additional.entrySet().stream().collect(Collectors.toMap(entry -> this.toSnakeCase((String)entry.getKey()), Map.Entry::getValue));
    }

    @JsonAnySetter
    public void addAdditionalProperty(String key, Object value) {
        this.additional.put(key, value);
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    public Map<String, Object> toMap() {
        try {
            String json = this.mapper.writeValueAsString((Object)this);
            Map map = (Map)this.mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
            map.remove("additional");
            return map;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String toSnakeCase(String input) {
        return input != null ? input.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase() : null;
    }

    public WatsonxAiChatOptions copy() {
        return WatsonxAiChatOptions.fromOptions(this);
    }

    public static class Builder {
        WatsonxAiChatOptions options = new WatsonxAiChatOptions();

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder topK(Integer topK) {
            this.options.topK = topK;
            return this;
        }

        public Builder decodingMethod(String decodingMethod) {
            this.options.decodingMethod = decodingMethod;
            return this;
        }

        public Builder maxNewTokens(Integer maxNewTokens) {
            this.options.maxNewTokens = maxNewTokens;
            return this;
        }

        public Builder minNewTokens(Integer minNewTokens) {
            this.options.minNewTokens = minNewTokens;
            return this;
        }

        public Builder stopSequences(List<String> stopSequences) {
            this.options.stopSequences = stopSequences;
            return this;
        }

        public Builder repetitionPenalty(Double repetitionPenalty) {
            this.options.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public Builder randomSeed(Integer randomSeed) {
            this.options.randomSeed = randomSeed;
            return this;
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder additionalProperty(String key, Object value) {
            this.options.additional.put(key, value);
            return this;
        }

        public Builder additionalProperties(Map<String, Object> properties) {
            this.options.additional.putAll(properties);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTemperature(Double temperature) {
            return this.temperature(temperature);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTopP(Double topP) {
            return this.topP(topP);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTopK(Integer topK) {
            return this.topK(topK);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withDecodingMethod(String decodingMethod) {
            return this.decodingMethod(decodingMethod);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMaxNewTokens(Integer maxNewTokens) {
            return this.maxNewTokens(maxNewTokens);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withMinNewTokens(Integer minNewTokens) {
            return this.minNewTokens(minNewTokens);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withStopSequences(List<String> stopSequences) {
            return this.stopSequences(stopSequences);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withRepetitionPenalty(Double repetitionPenalty) {
            return this.repetitionPenalty(repetitionPenalty);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withRandomSeed(Integer randomSeed) {
            return this.randomSeed(randomSeed);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(String model) {
            return this.model(model);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withAdditionalProperty(String key, Object value) {
            return this.additionalProperty(key, value);
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withAdditionalProperties(Map<String, Object> properties) {
            return this.additionalProperties(properties);
        }

        public WatsonxAiChatOptions build() {
            return this.options;
        }
    }
}

