/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.watsonx.api;

import com.ibm.cloud.sdk.core.security.IamAuthenticator;
import com.ibm.cloud.sdk.core.security.IamToken;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.watsonx.api.WatsonxAiChatRequest;
import org.springframework.ai.watsonx.api.WatsonxAiChatResponse;
import org.springframework.ai.watsonx.api.WatsonxAiEmbeddingRequest;
import org.springframework.ai.watsonx.api.WatsonxAiEmbeddingResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

public class WatsonxAiApi {
    public static final String WATSONX_REQUEST_CANNOT_BE_NULL = "Watsonx Request cannot be null";
    private static final Log logger = LogFactory.getLog(WatsonxAiApi.class);
    private final RestClient restClient;
    private final WebClient webClient;
    private final IamAuthenticator iamAuthenticator;
    private final String streamEndpoint;
    private final String textEndpoint;
    private final String embeddingEndpoint;
    private final String projectId;
    private IamToken token;

    public WatsonxAiApi(String baseUrl, String streamEndpoint, String textEndpoint, String embeddingEndpoint, String projectId, String IAMToken, RestClient.Builder restClientBuilder) {
        this.streamEndpoint = streamEndpoint;
        this.textEndpoint = textEndpoint;
        this.embeddingEndpoint = embeddingEndpoint;
        this.projectId = projectId;
        this.iamAuthenticator = IamAuthenticator.fromConfiguration(Map.of("APIKEY", IAMToken));
        this.token = this.iamAuthenticator.requestToken();
        Consumer<HttpHeaders> defaultHeaders = headers -> {
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultStatusHandler(RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER).defaultHeaders(defaultHeaders).build();
        this.webClient = WebClient.builder().baseUrl(baseUrl).defaultHeaders(defaultHeaders).build();
    }

    @Retryable(retryFor={Exception.class}, maxAttempts=3, backoff=@Backoff(random=true, delay=1200L, maxDelay=7000L, multiplier=2.5))
    public ResponseEntity<WatsonxAiChatResponse> generate(WatsonxAiChatRequest watsonxAiChatRequest) {
        Assert.notNull((Object)watsonxAiChatRequest, (String)WATSONX_REQUEST_CANNOT_BE_NULL);
        if (this.token.needsRefresh()) {
            this.token = this.iamAuthenticator.requestToken();
        }
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(this.textEndpoint, new Object[0])).header("Authorization", new String[]{"Bearer " + this.token.getAccessToken()})).body((Object)watsonxAiChatRequest.withProjectId(this.projectId)).retrieve().toEntity(WatsonxAiChatResponse.class);
    }

    @Retryable(retryFor={Exception.class}, maxAttempts=3, backoff=@Backoff(random=true, delay=1200L, maxDelay=7000L, multiplier=2.5))
    public Flux<WatsonxAiChatResponse> generateStreaming(WatsonxAiChatRequest watsonxAiChatRequest) {
        Assert.notNull((Object)watsonxAiChatRequest, (String)WATSONX_REQUEST_CANNOT_BE_NULL);
        if (this.token.needsRefresh()) {
            this.token = this.iamAuthenticator.requestToken();
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.streamEndpoint, new Object[0])).header("Authorization", new String[]{"Bearer " + this.token.getAccessToken()})).bodyValue((Object)watsonxAiChatRequest.withProjectId(this.projectId)).retrieve().bodyToFlux(WatsonxAiChatResponse.class).handle((data, sink) -> {
            if (logger.isTraceEnabled()) {
                logger.trace(data);
            }
            sink.next(data);
        });
    }

    @Retryable(retryFor={Exception.class}, maxAttempts=3, backoff=@Backoff(random=true, delay=1200L, maxDelay=7000L, multiplier=2.5))
    public ResponseEntity<WatsonxAiEmbeddingResponse> embeddings(WatsonxAiEmbeddingRequest request) {
        Assert.notNull((Object)request, (String)WATSONX_REQUEST_CANNOT_BE_NULL);
        if (this.token.needsRefresh()) {
            this.token = this.iamAuthenticator.requestToken();
        }
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(this.embeddingEndpoint, new Object[0])).header("Authorization", new String[]{"Bearer " + this.token.getAccessToken()})).body((Object)request.withProjectId(this.projectId)).retrieve().toEntity(WatsonxAiEmbeddingResponse.class);
    }
}

