/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.watsonx.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.springframework.ai.watsonx.WatsonxAiChatOptions;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class WatsonxAiChatRequest {
    @JsonProperty(value="input")
    private String input;
    @JsonProperty(value="parameters")
    private Map<String, Object> parameters;
    @JsonProperty(value="model_id")
    private String modelId = "";
    @JsonProperty(value="project_id")
    private String projectId = "";

    private WatsonxAiChatRequest(String input, Map<String, Object> parameters, String modelId, String projectId) {
        this.input = input;
        this.parameters = parameters;
        this.modelId = modelId;
        this.projectId = projectId;
    }

    public static Builder builder(String input) {
        return new Builder(input);
    }

    public WatsonxAiChatRequest withProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public String getInput() {
        return this.input;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getModelId() {
        return this.modelId;
    }

    public static class Builder {
        public static final String MODEL_PARAMETER_IS_REQUIRED = "Model parameter is required";
        private final String input;
        private Map<String, Object> parameters;
        private String model = "";

        public Builder(String input) {
            this.input = input;
        }

        public Builder withParameters(Map<String, Object> parameters) {
            Assert.notNull((Object)parameters.get("model"), (String)MODEL_PARAMETER_IS_REQUIRED);
            this.model = parameters.get("model").toString();
            this.parameters = WatsonxAiChatOptions.filterNonSupportedFields(parameters);
            return this;
        }

        public WatsonxAiChatRequest build() {
            return new WatsonxAiChatRequest(this.input, this.parameters, this.model, "");
        }
    }
}

