/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.watsonx.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class WatsonxAiEmbeddingRequest {
    @JsonProperty(value="model_id")
    String model;
    @JsonProperty(value="inputs")
    List<String> inputs;
    @JsonProperty(value="project_id")
    String projectId;

    private WatsonxAiEmbeddingRequest(String model, List<String> inputs, String projectId) {
        this.model = model;
        this.inputs = inputs;
        this.projectId = projectId;
    }

    public static Builder builder(List<String> inputs) {
        return new Builder(inputs);
    }

    public String getModel() {
        return this.model;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public WatsonxAiEmbeddingRequest withProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public static class Builder {
        private final List<String> inputs;
        private String model = "ibm/slate-30m-english-rtrvr";

        public Builder(List<String> inputs) {
            this.inputs = inputs;
        }

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public WatsonxAiEmbeddingRequest build() {
            return new WatsonxAiEmbeddingRequest(this.model, this.inputs, "");
        }
    }
}

