/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.zhipuai.api.ZhiPuAiApi;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ZhiPuAiChatOptions
implements FunctionCallingOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="tools")
    private List<ZhiPuAiApi.FunctionTool> tools;
    @JsonProperty(value="tools1")
    private List<ZhiPuAiApi.Foo> foos;
    @JsonProperty(value="tool_choice")
    private String toolChoice;
    @JsonProperty(value="user_id")
    private String user;
    @JsonProperty(value="request_id")
    private String requestId;
    @JsonProperty(value="do_sample")
    private Boolean doSample;
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();
    @JsonIgnore
    private Boolean proxyToolCalls;
    @JsonIgnore
    private Map<String, Object> toolContext;

    public static Builder builder() {
        return new Builder();
    }

    public static ZhiPuAiChatOptions fromOptions(ZhiPuAiChatOptions fromOptions) {
        return ZhiPuAiChatOptions.builder().model(fromOptions.getModel()).maxTokens(fromOptions.getMaxTokens()).stop(fromOptions.getStop()).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).tools(fromOptions.getTools()).toolChoice(fromOptions.getToolChoice()).user(fromOptions.getUser()).requestId(fromOptions.getRequestId()).doSample(fromOptions.getDoSample()).functionCallbacks(fromOptions.getFunctionCallbacks()).functions(fromOptions.getFunctions()).proxyToolCalls(fromOptions.getProxyToolCalls()).toolContext(fromOptions.getToolContext()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public List<ZhiPuAiApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<ZhiPuAiApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Boolean getDoSample() {
        return this.doSample;
    }

    public void setDoSample(Boolean doSample) {
        this.doSample = doSample;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functionNames) {
        this.functions = functionNames;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public Boolean getProxyToolCalls() {
        return this.proxyToolCalls;
    }

    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.maxTokens == null ? 0 : this.maxTokens.hashCode());
        result = 31 * result + (this.stop == null ? 0 : this.stop.hashCode());
        result = 31 * result + (this.temperature == null ? 0 : this.temperature.hashCode());
        result = 31 * result + (this.topP == null ? 0 : this.topP.hashCode());
        result = 31 * result + (this.tools == null ? 0 : this.tools.hashCode());
        result = 31 * result + (this.toolChoice == null ? 0 : this.toolChoice.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.proxyToolCalls == null ? 0 : this.proxyToolCalls.hashCode());
        result = 31 * result + (this.toolContext == null ? 0 : this.toolContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZhiPuAiChatOptions other = (ZhiPuAiChatOptions)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.maxTokens == null ? other.maxTokens != null : !this.maxTokens.equals(other.maxTokens)) {
            return false;
        }
        if (this.stop == null ? other.stop != null : !this.stop.equals(other.stop)) {
            return false;
        }
        if (this.temperature == null ? other.temperature != null : !this.temperature.equals(other.temperature)) {
            return false;
        }
        if (this.topP == null ? other.topP != null : !this.topP.equals(other.topP)) {
            return false;
        }
        if (this.tools == null ? other.tools != null : !this.tools.equals(other.tools)) {
            return false;
        }
        if (this.toolChoice == null ? other.toolChoice != null : !this.toolChoice.equals(other.toolChoice)) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
            return false;
        }
        if (this.requestId == null ? other.requestId != null : !this.requestId.equals(other.requestId)) {
            return false;
        }
        if (this.doSample == null ? other.doSample != null : !this.doSample.equals(other.doSample)) {
            return false;
        }
        if (this.proxyToolCalls == null ? other.proxyToolCalls != null : !this.proxyToolCalls.equals(other.proxyToolCalls)) {
            return false;
        }
        return !(this.toolContext == null ? other.toolContext != null : !this.toolContext.equals(other.toolContext));
    }

    public ZhiPuAiChatOptions copy() {
        return ZhiPuAiChatOptions.fromOptions(this);
    }

    public FunctionCallingOptions merge(ChatOptions options) {
        Builder builder = ZhiPuAiChatOptions.builder();
        builder.model(options.getModel() != null ? options.getModel() : this.getModel()).maxTokens(options.getMaxTokens() != null ? options.getMaxTokens() : this.getMaxTokens()).stop(options.getStopSequences() != null ? options.getStopSequences() : this.getStopSequences()).temperature(options.getTemperature() != null ? options.getTemperature() : this.getTemperature()).topP(options.getTopP() != null ? options.getTopP() : this.getTopP());
        if (options instanceof FunctionCallingOptions) {
            FunctionCallingOptions functionOptions = (FunctionCallingOptions)options;
            builder.proxyToolCalls(functionOptions.getProxyToolCalls() != null ? functionOptions.getProxyToolCalls() : this.proxyToolCalls);
            HashSet<String> functions = new HashSet<String>();
            if (this.functions != null) {
                functions.addAll(this.functions);
            }
            if (functionOptions.getFunctions() != null) {
                functions.addAll(functionOptions.getFunctions());
            }
            builder.functions(functions);
            ArrayList<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
            if (this.functionCallbacks != null) {
                functionCallbacks.addAll(this.functionCallbacks);
            }
            if (functionOptions.getFunctionCallbacks() != null) {
                functionCallbacks.addAll(functionOptions.getFunctionCallbacks());
            }
            builder.functionCallbacks(functionCallbacks);
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (this.toolContext != null) {
                context.putAll(this.toolContext);
            }
            if (functionOptions.getToolContext() != null) {
                context.putAll(functionOptions.getToolContext());
            }
            builder.toolContext(context);
        } else {
            builder.proxyToolCalls(this.proxyToolCalls);
            builder.functions((Set<String>)(this.functions != null ? new HashSet<String>(this.functions) : null));
            builder.functionCallbacks((List<FunctionCallback>)(this.functionCallbacks != null ? new ArrayList<FunctionCallback>(this.functionCallbacks) : null));
            builder.toolContext((Map<String, Object>)(this.toolContext != null ? new HashMap<String, Object>(this.toolContext) : null));
        }
        builder.tools(this.tools).toolChoice(this.toolChoice).user(this.user).requestId(this.requestId).doSample(this.doSample);
        return builder.build();
    }

    public static class Builder {
        protected ZhiPuAiChatOptions options;

        public Builder() {
            this.options = new ZhiPuAiChatOptions();
        }

        public Builder(ZhiPuAiChatOptions options) {
            this.options = options;
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder tools(List<ZhiPuAiApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder toolChoice(String toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder user(String user) {
            this.options.user = user;
            return this;
        }

        public Builder requestId(String requestId) {
            this.options.requestId = requestId;
            return this;
        }

        public Builder doSample(Boolean doSample) {
            this.options.doSample = doSample;
            return this;
        }

        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder functions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public Builder function(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public Builder proxyToolCalls(Boolean proxyToolCalls) {
            this.options.proxyToolCalls = proxyToolCalls;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public ZhiPuAiChatOptions build() {
            return this.options;
        }
    }
}

