/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.zhipuai.api.ZhiPuAiApi;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ZhiPuAiChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="tools")
    private List<ZhiPuAiApi.FunctionTool> tools;
    @JsonProperty(value="tools1")
    private List<ZhiPuAiApi.Foo> foos;
    @JsonProperty(value="tool_choice")
    private String toolChoice;
    @JsonProperty(value="user_id")
    private String user;
    @JsonProperty(value="request_id")
    private String requestId;
    @JsonProperty(value="do_sample")
    private Boolean doSample;
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();

    public static Builder builder() {
        return new Builder();
    }

    public static ZhiPuAiChatOptions fromOptions(ZhiPuAiChatOptions fromOptions) {
        return ZhiPuAiChatOptions.builder().model(fromOptions.getModel()).maxTokens(fromOptions.getMaxTokens()).stop(fromOptions.getStop()).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).tools(fromOptions.getTools()).toolChoice(fromOptions.getToolChoice()).user(fromOptions.getUser()).requestId(fromOptions.getRequestId()).doSample(fromOptions.getDoSample()).toolCallbacks(fromOptions.getToolCallbacks()).toolNames(fromOptions.getToolNames()).internalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled()).toolContext(fromOptions.getToolContext()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public List<ZhiPuAiApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<ZhiPuAiApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Boolean getDoSample() {
        return this.doSample;
    }

    public void setDoSample(Boolean doSample) {
        this.doSample = doSample;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    @JsonIgnore
    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    @JsonIgnore
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.maxTokens == null ? 0 : this.maxTokens.hashCode());
        result = 31 * result + (this.stop == null ? 0 : this.stop.hashCode());
        result = 31 * result + (this.temperature == null ? 0 : this.temperature.hashCode());
        result = 31 * result + (this.topP == null ? 0 : this.topP.hashCode());
        result = 31 * result + (this.tools == null ? 0 : this.tools.hashCode());
        result = 31 * result + (this.toolChoice == null ? 0 : this.toolChoice.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.internalToolExecutionEnabled == null ? 0 : this.internalToolExecutionEnabled.hashCode());
        result = 31 * result + (this.toolCallbacks == null ? 0 : this.toolCallbacks.hashCode());
        result = 31 * result + (this.toolNames == null ? 0 : this.toolNames.hashCode());
        result = 31 * result + (this.toolContext == null ? 0 : this.toolContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZhiPuAiChatOptions other = (ZhiPuAiChatOptions)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.maxTokens == null ? other.maxTokens != null : !this.maxTokens.equals(other.maxTokens)) {
            return false;
        }
        if (this.stop == null ? other.stop != null : !this.stop.equals(other.stop)) {
            return false;
        }
        if (this.temperature == null ? other.temperature != null : !this.temperature.equals(other.temperature)) {
            return false;
        }
        if (this.topP == null ? other.topP != null : !this.topP.equals(other.topP)) {
            return false;
        }
        if (this.tools == null ? other.tools != null : !this.tools.equals(other.tools)) {
            return false;
        }
        if (this.toolChoice == null ? other.toolChoice != null : !this.toolChoice.equals(other.toolChoice)) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
            return false;
        }
        if (this.requestId == null ? other.requestId != null : !this.requestId.equals(other.requestId)) {
            return false;
        }
        if (this.doSample == null ? other.doSample != null : !this.doSample.equals(other.doSample)) {
            return false;
        }
        if (this.internalToolExecutionEnabled == null ? other.internalToolExecutionEnabled != null : !this.internalToolExecutionEnabled.equals(other.internalToolExecutionEnabled)) {
            return false;
        }
        return !(this.toolContext == null ? other.toolContext != null : !this.toolContext.equals(other.toolContext));
    }

    public ZhiPuAiChatOptions copy() {
        return ZhiPuAiChatOptions.fromOptions(this);
    }

    public ToolCallingChatOptions merge(ChatOptions options) {
        Builder builder = ZhiPuAiChatOptions.builder();
        builder.model(options.getModel() != null ? options.getModel() : this.getModel()).maxTokens(options.getMaxTokens() != null ? options.getMaxTokens() : this.getMaxTokens()).stop(options.getStopSequences() != null ? options.getStopSequences() : this.getStopSequences()).temperature(options.getTemperature() != null ? options.getTemperature() : this.getTemperature()).topP(options.getTopP() != null ? options.getTopP() : this.getTopP());
        if (options instanceof ToolCallingChatOptions) {
            ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)options;
            builder.internalToolExecutionEnabled(toolCallingChatOptions.getInternalToolExecutionEnabled() != null ? toolCallingChatOptions.getInternalToolExecutionEnabled() : this.getInternalToolExecutionEnabled());
            HashSet<String> toolNames = new HashSet<String>();
            if (this.toolNames != null) {
                toolNames.addAll(this.toolNames);
            }
            if (toolCallingChatOptions.getToolNames() != null) {
                toolNames.addAll(toolCallingChatOptions.getToolNames());
            }
            builder.toolNames(toolNames);
            ArrayList<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
            if (this.toolCallbacks != null) {
                toolCallbacks.addAll(this.toolCallbacks);
            }
            if (toolCallingChatOptions.getToolCallbacks() != null) {
                toolCallbacks.addAll(toolCallingChatOptions.getToolCallbacks());
            }
            builder.toolCallbacks(toolCallbacks);
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (this.toolContext != null) {
                context.putAll(this.toolContext);
            }
            if (toolCallingChatOptions.getToolContext() != null) {
                context.putAll(toolCallingChatOptions.getToolContext());
            }
            builder.toolContext(context);
        } else {
            builder.internalToolExecutionEnabled(this.internalToolExecutionEnabled);
            builder.toolNames((Set<String>)(this.toolNames != null ? new HashSet<String>(this.toolNames) : null));
            builder.toolCallbacks((List<ToolCallback>)(this.toolCallbacks != null ? new ArrayList<ToolCallback>(this.toolCallbacks) : null));
            builder.toolContext((Map<String, Object>)(this.toolContext != null ? new HashMap<String, Object>(this.toolContext) : null));
        }
        builder.tools(this.tools).toolChoice(this.toolChoice).user(this.user).requestId(this.requestId).doSample(this.doSample);
        return builder.build();
    }

    public static class Builder {
        protected ZhiPuAiChatOptions options;

        public Builder() {
            this.options = new ZhiPuAiChatOptions();
        }

        public Builder(ZhiPuAiChatOptions options) {
            this.options = options;
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder tools(List<ZhiPuAiApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder toolChoice(String toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder user(String user) {
            this.options.user = user;
            return this;
        }

        public Builder requestId(String requestId) {
            this.options.requestId = requestId;
            return this;
        }

        public Builder doSample(Boolean doSample) {
            this.options.doSample = doSample;
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public ZhiPuAiChatOptions build() {
            return this.options;
        }
    }
}

