/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.AbstractDeclarable;
import org.springframework.amqp.core.Base64UrlNamingStrategy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Queue
extends AbstractDeclarable {
    public static final String X_QUEUE_MASTER_LOCATOR = "x-queue-master-locator";
    private final String name;
    private final boolean durable;
    private final boolean exclusive;
    private final boolean autoDelete;
    private final Map<String, Object> arguments;
    private volatile String actualName;

    public Queue(String name) {
        this(name, true, false, false);
    }

    public Queue(String name, boolean durable) {
        this(name, durable, false, false, null);
    }

    public Queue(String name, boolean durable, boolean exclusive, boolean autoDelete) {
        this(name, durable, exclusive, autoDelete, null);
    }

    public Queue(String name, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        Assert.notNull((Object)name, (String)"'name' cannot be null");
        this.name = name;
        this.actualName = StringUtils.hasText((String)name) ? name : Base64UrlNamingStrategy.DEFAULT.generateName() + "_awaiting_declaration";
        this.durable = durable;
        this.exclusive = exclusive;
        this.autoDelete = autoDelete;
        this.arguments = arguments != null ? arguments : new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public void setActualName(String name) {
        this.actualName = name;
    }

    public String getActualName() {
        return this.actualName;
    }

    public final void setMasterLocator(@Nullable String locator) {
        if (locator == null) {
            this.arguments.remove(X_QUEUE_MASTER_LOCATOR);
        } else {
            this.arguments.put(X_QUEUE_MASTER_LOCATOR, locator);
        }
    }

    public String toString() {
        return "Queue [name=" + this.name + ", durable=" + this.durable + ", autoDelete=" + this.autoDelete + ", exclusive=" + this.exclusive + ", arguments=" + this.arguments + ", actualName=" + this.actualName + "]";
    }
}

