/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.util.Map;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.amqp.support.SimpleAmqpHeaderMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class MessagingMessageConverter
implements MessageConverter,
InitializingBean {
    private MessageConverter payloadConverter;
    private AmqpHeaderMapper headerMapper;

    public MessagingMessageConverter() {
        this(new SimpleMessageConverter(), new SimpleAmqpHeaderMapper());
    }

    public MessagingMessageConverter(MessageConverter payloadConverter, AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)payloadConverter, (String)"PayloadConverter must not be null");
        Assert.notNull((Object)headerMapper, (String)"HeaderMapper must not be null");
        this.payloadConverter = payloadConverter;
        this.headerMapper = headerMapper;
    }

    public void setPayloadConverter(MessageConverter payloadConverter) {
        this.payloadConverter = payloadConverter;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public AmqpHeaderMapper getHeaderMapper() {
        return this.headerMapper;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.payloadConverter, (String)"Property 'payloadConverter' is required");
        Assert.notNull((Object)this.headerMapper, (String)"Property 'headerMapper' is required");
    }

    @Override
    public org.springframework.amqp.core.Message toMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        if (!(object instanceof Message)) {
            throw new IllegalArgumentException("Could not convert [" + object + "] - only [" + Message.class.getName() + "] is handled by this converter");
        }
        Message input = (Message)object;
        org.springframework.amqp.core.Message amqpMessage = this.payloadConverter.toMessage(input.getPayload(), messageProperties);
        this.headerMapper.fromHeaders(input.getHeaders(), messageProperties);
        return amqpMessage;
    }

    @Override
    public Object fromMessage(org.springframework.amqp.core.Message message) throws MessageConversionException {
        if (message == null) {
            return null;
        }
        MessageHeaders mappedHeaders = this.headerMapper.toHeaders(message.getMessageProperties());
        Object convertedObject = this.extractPayload(message);
        if (convertedObject == null) {
            throw new MessageConversionException("Message converter returned null");
        }
        MessageBuilder builder = convertedObject instanceof Message ? MessageBuilder.fromMessage((Message)((Message)convertedObject)) : MessageBuilder.withPayload((Object)convertedObject);
        return builder.copyHeadersIfAbsent((Map)mappedHeaders).build();
    }

    protected Object extractPayload(org.springframework.amqp.core.Message message) {
        return this.payloadConverter.fromMessage(message);
    }
}

