/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.utils.SerializationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class Message
implements Serializable {
    private static final long serialVersionUID = -7177590352110605597L;
    private static final String DEFAULT_ENCODING = Charset.defaultCharset().name();
    private static final Set<String> ALLOWED_LIST_PATTERNS = new LinkedHashSet<String>(Arrays.asList("java.util.*", "java.lang.*"));
    private static String bodyEncoding = DEFAULT_ENCODING;
    private final MessageProperties messageProperties;
    private final byte[] body;

    public Message(byte[] body, MessageProperties messageProperties) {
        this.body = body;
        this.messageProperties = messageProperties;
    }

    public static void addAllowedListPatterns(String ... patterns) {
        Assert.notNull((Object)patterns, (String)"'patterns' cannot be null");
        ALLOWED_LIST_PATTERNS.addAll(Arrays.asList(patterns));
    }

    public static void setDefaultEncoding(String encoding) {
        Assert.notNull((Object)encoding, (String)"'encoding' cannot be null");
        bodyEncoding = encoding;
    }

    public byte[] getBody() {
        return this.body;
    }

    public MessageProperties getMessageProperties() {
        return this.messageProperties;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        buffer.append("Body:'").append(this.getBodyContentAsString()).append("'");
        if (this.messageProperties != null) {
            buffer.append(" ").append(this.messageProperties.toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String getBodyContentAsString() {
        if (this.body == null) {
            return null;
        }
        try {
            String contentType;
            boolean nullProps = this.messageProperties == null;
            String string = contentType = nullProps ? null : this.messageProperties.getContentType();
            if ("application/x-java-serialized-object".equals(contentType)) {
                return SerializationUtils.deserialize(new ByteArrayInputStream(this.body), ALLOWED_LIST_PATTERNS, ClassUtils.getDefaultClassLoader()).toString();
            }
            String encoding = this.encoding(nullProps);
            if ("text/plain".equals(contentType) || "application/json".equals(contentType) || "text/x-json".equals(contentType) || "application/xml".equals(contentType)) {
                return new String(this.body, encoding);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.body.toString() + "(byte[" + this.body.length + "])";
    }

    private String encoding(boolean nullProps) {
        String encoding;
        String string = encoding = nullProps ? null : this.messageProperties.getContentEncoding();
        if (encoding == null) {
            encoding = bodyEncoding;
        }
        return encoding;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.body);
        result = 31 * result + (this.messageProperties == null ? 0 : this.messageProperties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (!Arrays.equals(this.body, other.body)) {
            return false;
        }
        return !(this.messageProperties == null ? other.messageProperties != null : !this.messageProperties.equals(other.messageProperties));
    }
}

