/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.postprocessor;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;

public final class MessagePostProcessorUtils {
    public static Collection<MessagePostProcessor> sort(Collection<MessagePostProcessor> processors) {
        ArrayList<MessagePostProcessor> priorityOrdered = new ArrayList<MessagePostProcessor>();
        ArrayList<MessagePostProcessor> ordered = new ArrayList<MessagePostProcessor>();
        ArrayList<MessagePostProcessor> unOrdered = new ArrayList<MessagePostProcessor>();
        for (MessagePostProcessor processor : processors) {
            if (processor instanceof PriorityOrdered) {
                priorityOrdered.add(processor);
                continue;
            }
            if (processor instanceof Ordered) {
                ordered.add(processor);
                continue;
            }
            unOrdered.add(processor);
        }
        ArrayList<MessagePostProcessor> sorted = new ArrayList<MessagePostProcessor>();
        OrderComparator.sort(priorityOrdered);
        sorted.addAll(priorityOrdered);
        OrderComparator.sort(ordered);
        sorted.addAll(ordered);
        sorted.addAll(unOrdered);
        return sorted;
    }

    private MessagePostProcessorUtils() {
    }
}

