/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.AbstractHeaderMapper;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class SimpleAmqpHeaderMapper
extends AbstractHeaderMapper<MessageProperties>
implements AmqpHeaderMapper {
    public void fromHeaders(MessageHeaders headers, MessageProperties amqpMessageProperties) {
        String replyToStack;
        JavaUtils javaUtils = JavaUtils.INSTANCE.acceptIfHasText((String)this.getHeaderIfAvailable((Map)headers, "amqp_appId", String.class), amqpMessageProperties::setAppId).acceptIfHasText((String)this.getHeaderIfAvailable((Map)headers, "amqp_clusterId", String.class), amqpMessageProperties::setClusterId).acceptIfHasText((String)this.getHeaderIfAvailable((Map)headers, "amqp_contentEncoding", String.class), amqpMessageProperties::setContentEncoding).acceptIfNotNull((Long)this.getHeaderIfAvailable((Map)headers, "amqp_contentLength", Long.class), amqpMessageProperties::setContentLength).acceptIfHasText(this.extractContentTypeAsString((Map<String, Object>)headers), amqpMessageProperties::setContentType);
        Object correlationId = headers.get((Object)"amqp_correlationId");
        if (correlationId instanceof String) {
            String string = (String)correlationId;
            amqpMessageProperties.setCorrelationId(string);
        }
        javaUtils.acceptIfNotNull((Long)this.getHeaderIfAvailable((Map)headers, "amqp_delay", Long.class), amqpMessageProperties::setDelayLong).acceptIfNotNull((MessageDeliveryMode)((Object)this.getHeaderIfAvailable((Map)headers, "amqp_deliveryMode", MessageDeliveryMode.class)), amqpMessageProperties::setDeliveryMode).acceptIfNotNull((Long)this.getHeaderIfAvailable((Map)headers, "amqp_deliveryTag", Long.class), amqpMessageProperties::setDeliveryTag).acceptIfHasText((String)this.getHeaderIfAvailable((Map)headers, "amqp_expiration", String.class), amqpMessageProperties::setExpiration).acceptIfNotNull((Integer)this.getHeaderIfAvailable((Map)headers, "amqp_messageCount", Integer.class), amqpMessageProperties::setMessageCount).acceptIfHasText((String)this.getHeaderIfAvailable((Map)headers, "amqp_messageId", String.class), amqpMessageProperties::setMessageId).acceptIfNotNull((Integer)this.getHeaderIfAvailable((Map)headers, "priority", Integer.class), amqpMessageProperties::setPriority).acceptIfHasText((String)this.getHeaderIfAvailable((Map)headers, "amqp_receivedExchange", String.class), amqpMessageProperties::setReceivedExchange).acceptIfHasText((String)this.getHeaderIfAvailable((Map)headers, "amqp_receivedRoutingKey", String.class), amqpMessageProperties::setReceivedRoutingKey).acceptIfNotNull((Boolean)this.getHeaderIfAvailable((Map)headers, "amqp_redelivered", Boolean.class), amqpMessageProperties::setRedelivered).acceptIfNotNull((String)this.getHeaderIfAvailable((Map)headers, "amqp_replyTo", String.class), amqpMessageProperties::setReplyTo).acceptIfNotNull((Date)this.getHeaderIfAvailable((Map)headers, "amqp_timestamp", Date.class), amqpMessageProperties::setTimestamp).acceptIfNotNull((String)this.getHeaderIfAvailable((Map)headers, "amqp_type", String.class), amqpMessageProperties::setType).acceptIfNotNull((Long)this.getHeaderIfAvailable((Map)headers, "amqp_retryCount", Long.class), amqpMessageProperties::setRetryCount).acceptIfHasText((String)this.getHeaderIfAvailable((Map)headers, "amqp_userId", String.class), amqpMessageProperties::setUserId);
        String replyCorrelation = (String)this.getHeaderIfAvailable((Map)headers, "amqp_springReplyCorrelation", String.class);
        if (StringUtils.hasLength((String)replyCorrelation)) {
            amqpMessageProperties.setHeader("spring_reply_correlation", replyCorrelation);
        }
        if (StringUtils.hasLength((String)(replyToStack = (String)this.getHeaderIfAvailable((Map)headers, "amqp_springReplyToStack", String.class)))) {
            amqpMessageProperties.setHeader("spring_reply_to", replyToStack);
        }
        for (Map.Entry entry : headers.entrySet()) {
            Object value;
            String headerName = (String)entry.getKey();
            if (!StringUtils.hasText((String)headerName) || headerName.startsWith("amqp_") || (value = entry.getValue()) == null) continue;
            String propertyName = this.fromHeaderName(headerName);
            if (amqpMessageProperties.getHeaders().containsKey(headerName)) continue;
            amqpMessageProperties.setHeader(propertyName, value);
        }
    }

    public MessageHeaders toHeaders(MessageProperties amqpMessageProperties) {
        HashMap<String, Object> headers;
        block2: {
            headers = new HashMap<String, Object>();
            try {
                BiConsumer<String, Object> putObject = headers::put;
                BiConsumer<String, String> putString = headers::put;
                JavaUtils javaUtils = JavaUtils.INSTANCE.acceptIfNotNull("amqp_appId", amqpMessageProperties.getAppId(), putObject).acceptIfNotNull("amqp_clusterId", amqpMessageProperties.getClusterId(), putObject).acceptIfNotNull("amqp_contentEncoding", amqpMessageProperties.getContentEncoding(), putObject);
                long contentLength = amqpMessageProperties.getContentLength();
                javaUtils.acceptIfCondition(contentLength > 0L, "amqp_contentLength", contentLength, putObject).acceptIfHasText("contentType", amqpMessageProperties.getContentType(), putString).acceptIfHasText("amqp_correlationId", amqpMessageProperties.getCorrelationId(), putString).acceptIfNotNull("amqp_receivedDeliveryMode", amqpMessageProperties.getReceivedDeliveryMode(), putObject);
                long deliveryTag = amqpMessageProperties.getDeliveryTag();
                javaUtils.acceptIfCondition(deliveryTag > 0L, "amqp_deliveryTag", deliveryTag, putObject).acceptIfHasText("amqp_expiration", amqpMessageProperties.getExpiration(), putString).acceptIfNotNull("amqp_messageCount", amqpMessageProperties.getMessageCount(), putObject).acceptIfNotNull("amqp_messageId", amqpMessageProperties.getMessageId(), putObject);
                Integer priority = amqpMessageProperties.getPriority();
                javaUtils.acceptIfCondition(priority != null && priority > 0, "priority", priority, putObject).acceptIfNotNull("amqp_receivedDelay", amqpMessageProperties.getReceivedDelayLong(), putObject).acceptIfHasText("amqp_receivedExchange", amqpMessageProperties.getReceivedExchange(), putString).acceptIfHasText("amqp_receivedRoutingKey", amqpMessageProperties.getReceivedRoutingKey(), putString).acceptIfNotNull("amqp_redelivered", amqpMessageProperties.isRedelivered(), putObject).acceptIfNotNull("amqp_replyTo", amqpMessageProperties.getReplyTo(), putObject).acceptIfNotNull("amqp_timestamp", amqpMessageProperties.getTimestamp(), putObject).acceptIfHasText("amqp_type", amqpMessageProperties.getType(), putString).acceptIfHasText("amqp_receivedUserId", amqpMessageProperties.getReceivedUserId(), putString).acceptIfHasText("amqp_consumerTag", amqpMessageProperties.getConsumerTag(), putString).acceptIfHasText("amqp_consumerQueue", amqpMessageProperties.getConsumerQueue(), putString);
                headers.put("amqp_lastInBatch", amqpMessageProperties.isLastInBatch());
                headers.put("amqp_retryCount", amqpMessageProperties.getRetryCount());
                headers.putAll(amqpMessageProperties.getHeaders());
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn((Object)"error occurred while mapping from AMQP properties to MessageHeaders", (Throwable)e);
            }
        }
        return new MessageHeaders(headers);
    }

    private String extractContentTypeAsString(Map<String, Object> headers) {
        String contentTypeStringValue = null;
        Object contentType = this.getHeaderIfAvailable(headers, "contentType", Object.class);
        if (contentType != null) {
            if (contentType instanceof MimeType) {
                contentTypeStringValue = contentType.toString();
            } else if (contentType instanceof String) {
                String string;
                contentTypeStringValue = string = (String)contentType;
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("skipping header 'contentType' since it is not of expected type [" + contentType.getClass().getName() + "]"));
            }
        }
        return contentTypeStringValue;
    }
}

