/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.util.Assert;

public class ConsistentHashExchange
extends AbstractExchange {
    public ConsistentHashExchange(String name) {
        super(name);
    }

    public ConsistentHashExchange(String name, boolean durable, boolean autoDelete) {
        super(name, durable, autoDelete);
    }

    public ConsistentHashExchange(String name, boolean durable, boolean autoDelete, @Nullable Map<String, @Nullable Object> arguments) {
        super(name, durable, autoDelete, arguments);
        Assert.isTrue((arguments == null || !arguments.containsKey("hash-header") || !arguments.containsKey("hash-property") ? 1 : 0) != 0, (String)"The 'hash-header' and 'hash-property' are mutually exclusive.");
    }

    public void setHashHeader(String headerName) {
        Map<String, Object> arguments = this.getArguments();
        Assert.isTrue((!arguments.containsKey("hash-property") ? 1 : 0) != 0, (String)"The 'hash-header' and 'hash-property' are mutually exclusive.");
        arguments.put("hash-header", headerName);
    }

    public void setHashProperty(String propertyName) {
        Map<String, Object> arguments = this.getArguments();
        Assert.isTrue((!arguments.containsKey("hash-header") ? 1 : 0) != 0, (String)"The 'hash-header' and 'hash-property' are mutually exclusive.");
        arguments.put("hash-property", propertyName);
    }

    @Override
    public String getType() {
        return "x-consistent-hash";
    }
}

