/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class AmqpMessageHeaderAccessor
extends NativeMessageHeaderAccessor {
    public static final String PRIORITY = "priority";

    protected AmqpMessageHeaderAccessor(Map<String, List<String>> nativeHeaders) {
        super(nativeHeaders);
    }

    protected AmqpMessageHeaderAccessor(Message<?> message) {
        super(message);
    }

    public static AmqpMessageHeaderAccessor wrap(Message<?> message) {
        return new AmqpMessageHeaderAccessor(message);
    }

    protected void verifyType(@Nullable String headerName, @Nullable Object headerValue) {
        super.verifyType(headerName, headerValue);
        if (PRIORITY.equals(headerName)) {
            Assert.isTrue((boolean)Integer.class.isAssignableFrom(headerValue.getClass()), (String)("The '" + headerName + "' header value must be an Integer."));
        }
    }

    public @Nullable String getAppId() {
        return (String)this.getHeader("amqp_appId");
    }

    public @Nullable String getClusterId() {
        return (String)this.getHeader("amqp_clusterId");
    }

    public @Nullable String getContentEncoding() {
        return (String)this.getHeader("amqp_contentEncoding");
    }

    public @Nullable Long getContentLength() {
        return (Long)this.getHeader("amqp_contentLength");
    }

    public @Nullable MimeType getContentType() {
        Object value = this.getHeader("contentType");
        if (value instanceof String) {
            String contentType = (String)value;
            return MimeType.valueOf((String)contentType);
        }
        return super.getContentType();
    }

    public @Nullable String getCorrelationId() {
        return (String)this.getHeader("amqp_correlationId");
    }

    public @Nullable MessageDeliveryMode getDeliveryMode() {
        return (MessageDeliveryMode)((Object)this.getHeader("amqp_deliveryMode"));
    }

    public @Nullable MessageDeliveryMode getReceivedDeliveryMode() {
        return (MessageDeliveryMode)((Object)this.getHeader("amqp_receivedDeliveryMode"));
    }

    public @Nullable Long getDeliveryTag() {
        return (Long)this.getHeader("amqp_deliveryTag");
    }

    public @Nullable String getExpiration() {
        return (String)this.getHeader("amqp_expiration");
    }

    public @Nullable Integer getMessageCount() {
        return (Integer)this.getHeader("amqp_messageCount");
    }

    public @Nullable String getMessageId() {
        return (String)this.getHeader("amqp_messageId");
    }

    public @Nullable Integer getPriority() {
        return (Integer)this.getHeader(PRIORITY);
    }

    public @Nullable String getReceivedExchange() {
        return (String)this.getHeader("amqp_receivedExchange");
    }

    public @Nullable String getReceivedRoutingKey() {
        return (String)this.getHeader("amqp_receivedRoutingKey");
    }

    public @Nullable String getReceivedUserId() {
        return (String)this.getHeader("amqp_receivedUserId");
    }

    public @Nullable Boolean getRedelivered() {
        return (Boolean)this.getHeader("amqp_redelivered");
    }

    public @Nullable String getReplyTo() {
        return (String)this.getHeader("amqp_replyTo");
    }

    public @Nullable Long getTimestamp() {
        Date amqpTimestamp = (Date)this.getHeader("amqp_timestamp");
        if (amqpTimestamp != null) {
            return amqpTimestamp.getTime();
        }
        return super.getTimestamp();
    }

    public @Nullable String getType() {
        return (String)this.getHeader("amqp_type");
    }

    public @Nullable String getUserId() {
        return (String)this.getHeader("amqp_userId");
    }

    public @Nullable String getConsumerTag() {
        return (String)this.getHeader("amqp_consumerTag");
    }

    public @Nullable String getConsumerQueue() {
        return (String)this.getHeader("amqp_consumerQueue");
    }
}

