/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractJacksonMessageConverter;
import org.springframework.amqp.support.converter.JacksonProjectingMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeTypeUtils;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;

public class JacksonJsonMessageConverter
extends AbstractJacksonMessageConverter {
    private @Nullable JacksonProjectingMessageConverter projectingConverter;

    public JacksonJsonMessageConverter() {
        this("*");
    }

    public JacksonJsonMessageConverter(String ... trustedPackages) {
        this(((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules(JacksonJsonMessageConverter.class.getClassLoader())).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION})).build(), trustedPackages);
    }

    public JacksonJsonMessageConverter(JsonMapper jsonMapper) {
        this(jsonMapper, "*");
    }

    public JacksonJsonMessageConverter(JsonMapper jsonMapper, String ... trustedPackages) {
        super((ObjectMapper)jsonMapper, MimeTypeUtils.parseMimeType((String)"application/json"), trustedPackages);
    }

    public void setUseProjectionForInterfaces(boolean useProjectionForInterfaces) {
        if (useProjectionForInterfaces) {
            if (!ClassUtils.isPresent((String)"org.springframework.data.projection.ProjectionFactory", (ClassLoader)this.getClassLoader())) {
                throw new IllegalStateException("'spring-data-commons' is required to use Projection Interfaces");
            }
            this.projectingConverter = new JacksonProjectingMessageConverter((JsonMapper)this.objectMapper);
        }
    }

    protected boolean isUseProjectionForInterfaces() {
        return this.projectingConverter != null;
    }

    @Override
    protected Object convertContent(Message message, @Nullable Object conversionHint, MessageProperties properties, @Nullable String encoding) throws IOException {
        Object content = null;
        JavaType inferredType = this.getJavaTypeMapper().getInferredType(properties);
        if (inferredType != null && this.projectingConverter != null && inferredType.isInterface() && !inferredType.getRawClass().getPackage().getName().startsWith("java.util")) {
            content = this.projectingConverter.convert(message, inferredType.getRawClass());
            properties.setProjectionUsed(true);
        }
        if (content == null) {
            return super.convertContent(message, conversionHint, properties, encoding);
        }
        return content;
    }
}

