/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.ClassMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultClassMapper
implements ClassMapper,
InitializingBean {
    public static final String DEFAULT_CLASSID_FIELD_NAME = "__TypeId__";
    private static final String DEFAULT_HASHTABLE_TYPE_ID = "Hashtable";
    private static final List<String> TRUSTED_PACKAGES = Arrays.asList("java.util", "java.lang");
    private final Set<String> trustedPackages = new LinkedHashSet<String>(TRUSTED_PACKAGES);
    private final Map<Class<?>, String> classIdMapping = new HashMap();
    private volatile Map<String, Class<?>> idClassMapping = new HashMap();
    private volatile Class<?> defaultMapClass = LinkedHashMap.class;
    private volatile Class<?> defaultType = LinkedHashMap.class;

    public void setDefaultType(Class<?> defaultType) {
        Assert.notNull(defaultType, (String)"'defaultType' cannot be null");
        this.defaultType = defaultType;
    }

    public void setDefaultMapClass(Class<?> defaultMapClass) {
        this.defaultMapClass = defaultMapClass;
    }

    public String getClassIdFieldName() {
        return DEFAULT_CLASSID_FIELD_NAME;
    }

    public void setIdClassMapping(Map<String, Class<?>> idClassMapping) {
        this.idClassMapping = idClassMapping;
    }

    public void setTrustedPackages(String ... trustedPackages) {
        if (trustedPackages != null) {
            for (String trusted : trustedPackages) {
                if ("*".equals(trusted)) {
                    this.trustedPackages.clear();
                    break;
                }
                this.trustedPackages.add(trusted);
            }
        }
    }

    private String fromClass(Class<?> classOfObjectToConvert) {
        if (this.classIdMapping.containsKey(classOfObjectToConvert)) {
            return this.classIdMapping.get(classOfObjectToConvert);
        }
        if (Map.class.isAssignableFrom(classOfObjectToConvert)) {
            return DEFAULT_HASHTABLE_TYPE_ID;
        }
        return classOfObjectToConvert.getName();
    }

    public void afterPropertiesSet() {
        this.validateIdTypeMapping();
    }

    private void validateIdTypeMapping() {
        HashMap finalIdClassMapping = new HashMap();
        this.classIdMapping.clear();
        for (Map.Entry<String, Class<?>> entry : this.idClassMapping.entrySet()) {
            String id = entry.getKey();
            Class<?> clazz = entry.getValue();
            finalIdClassMapping.put(id, clazz);
            this.classIdMapping.put(clazz, id);
        }
        this.idClassMapping = finalIdClassMapping;
    }

    @Override
    public void fromClass(Class<?> clazz, MessageProperties properties) {
        properties.getHeaders().put(this.getClassIdFieldName(), this.fromClass(clazz));
    }

    @Override
    public Class<?> toClass(MessageProperties properties) {
        Map<String, @Nullable Object> headers = properties.getHeaders();
        Object classIdFieldNameValue = headers.get(this.getClassIdFieldName());
        String classId = null;
        if (classIdFieldNameValue != null) {
            classId = classIdFieldNameValue.toString();
        }
        if (classId == null) {
            return this.defaultType;
        }
        return this.toClass(classId);
    }

    private Class<?> toClass(String classId) {
        if (this.idClassMapping.containsKey(classId)) {
            return this.idClassMapping.get(classId);
        }
        if (classId.equals(DEFAULT_HASHTABLE_TYPE_ID)) {
            return this.defaultMapClass;
        }
        try {
            if (!this.isTrustedPackage(classId)) {
                throw new IllegalArgumentException("The class '" + classId + "' is not in the trusted packages: " + String.valueOf(this.trustedPackages) + ". If you believe this class is safe to deserialize, please provide its name. If the serialization is only done by a trusted source, you can also enable trust all (*).");
            }
            return ClassUtils.forName((String)classId, (ClassLoader)ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new MessageConversionException("failed to resolve class name [" + classId + "]", e);
        }
    }

    private boolean isTrustedPackage(String requestedType) {
        if (!this.trustedPackages.isEmpty()) {
            String packageName = ClassUtils.getPackageName((String)requestedType).replaceFirst("\\[L", "");
            for (String trustedPackage : this.trustedPackages) {
                if (!packageName.equals(trustedPackage)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

